% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_imagem.R
\name{image_segment_kmeans}
\alias{image_segment_kmeans}
\title{Image segmentation using k-means clustering}
\usage{
image_segment_kmeans(
  img,
  bands = 1:3,
  nclasses = 2,
  invert = FALSE,
  filter = FALSE,
  fill_hull = FALSE,
  plot = TRUE
)
}
\arguments{
\item{img}{An \code{Image} object.}

\item{bands}{A numeric integer/vector indicating the RGB band used in the
segmentation. Defaults to \code{1:3}, i.e., all the RGB bands are used.}

\item{nclasses}{The number of desired classes after image segmentation.}

\item{invert}{Invert the segmentation? Defaults to \code{FALSE}. If \code{TRUE} the
binary matrix is inverted.}

\item{filter}{Applies a median filtering in the binary matrix? Defaults to
\code{FALSE}. Use a numeric integer to indicate the size of the median filter.}

\item{fill_hull}{Fill holes in the objects? Defaults to \code{FALSE}.}

\item{plot}{Plot the segmented image?}
}
\value{
A list with the following values:
\itemize{
\item \code{image} The segmented image considering only two classes (foreground and
background)
\item \code{clusters} The class of each pixel. For example, if \code{ncluster = 3},
\code{clusters} will be a two-way matrix with values ranging from 1 to 3.
\code{masks} A list with the binary matrices showing the segmentation.
}
}
\description{
Segments image objects using clustering by the k-means clustering algorithm
}
\examples{
img <- image_pliman("la_leaves.jpg", plot = TRUE)
seg <- image_segment_kmeans(img)
seg <- image_segment_kmeans(img, fill_hull = TRUE, invert = TRUE, filter = 10)
}
\references{
Hartigan, J. A. and Wong, M. A. (1979). Algorithm AS 136: A
K-means clustering algorithm. Applied Statistics, 28, 100–108.
\doi{10.2307/2346830}
}
