% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_mapedit.R
\name{custom_palette}
\alias{custom_palette}
\title{Generate Custom Color Palette}
\usage{
custom_palette(
  colors = c("#4B0055", "#00588B", "#009B95", "#53CC67", "yellow"),
  n = 100
)
}
\arguments{
\item{colors}{A vector of colors to create the color palette. Default is
c("steelblue", "salmon", "forestgreen").}

\item{n}{The number of gradient colors in the color palette. Default is 100.}
}
\value{
A vector of colors representing the custom color palette.
}
\description{
This function generates a custom color palette using the specified colors and
number of colors.
}
\examples{
# Generate a custom color palette with default colors and 10 colors
custom_palette()

# Generate a custom color palette with specified colors and 20 colors
custom_palette(colors = c("blue", "red"), n = 20)

# example code
library(pliman)
custom_palette(n = 5)

}
