\name{print.bayesplfm}
\alias{print.bayesplfm}
\title{Printing  \code{\link{bayesplfm}} objects
}
\description{
Printing method for objects generated by the \code{\link{bayesplfm}} function.
}
\usage{
\method{print}{bayesplfm}(x,\dots)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
\item{x}{Object returned by \code{\link{bayesplfm}}.}
\item{\dots}{Further arguments are ignored.}
}
\details{
The printing method for Bayesian probabilistic latent feature analysis objects displays 
	(1) the parameters used to call the \code{\link{bayesplfm}} function,
        (2) the number of parameters that do not meet the convergence criterion   
	(3) information on the descriptive fit of the model (i.e. correlation between observed and expected frequencies, 
	and proportion of the variance in the observed frequencies accounted for by the model), 
	and (4) the posterior mean of the object- and attribute parameters.
}
\seealso{
\code{\link{bayesplfm}},\code{\link{summary.bayesplfm}},\code{\link{print.summary.bayesplfm}}
}
\examples{

\dontrun{
##load car data
data(car)


## Compute a sample of the posterior distribution 
## for the disjunctive model with two features
## compute the starting point using plfm
carbayes2<-bayesplfm(maprule="disj",freq1=car$freq1,freqtot=car$freqtot,F=2,
                      maxNiter=500,Nburnin=0,Nstep=100,Nchains=2,
                      start.bayes="best")


## print the object generated by bayesplfm
carbayes2
}

}