% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item_data.R
\name{ItemData}
\alias{ItemData}
\title{Prepares data for up-dating scale value parameters of nominal model}
\usage{
ItemData(
  Master,
  ItemID,
  Phi.mat = Phi.mat,
  npersons,
  nitems,
  ntraits,
  ncat,
  nless,
  TraitByTrait,
  pq.mat,
  LambdaName,
  NuName
)
}
\arguments{
\item{Master}{Master data frame}

\item{ItemID}{The item for which scale values are being up-dated}

\item{Phi.mat}{Current estimate conditional covariance matrix
(i.e., association paramters)}

\item{npersons}{Number of persons}

\item{nitems}{Number of items}

\item{ntraits}{Number of traits}

\item{ncat}{Number of categories}

\item{nless}{Number of unique lambdas and unique nus}

\item{TraitByTrait}{Same as inTraitAdj}

\item{pq.mat}{One dimemsinal array used to get rest and totals scores}

\item{LambdaName}{Name of lambdas for in item regression}

\item{NuName}{Name of nus in item regression}
}
\value{
ItemFit 	Data frame used to up-date scale values
}
\description{
This function creates a data frame, 'item data', to be used in the item
regressions for nominal models. It computes weighted rest scores and totals,
including correlated traits. This function is internal to 'ItemLoop' and
it is unlikely to be run outside of 'fit.nominal' or 'ple.lma'.
}
