% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.gen.R
\name{sim.ltrc}
\alias{sim.ltrc}
\title{Generate left-truncated (and right-cencored) data from the Cox model.}
\usage{
sim.ltrc(n = 200, b = c(1, 1), time.dep = FALSE, Zv.depA = FALSE,
  distr.T = "weibull", shape.T = 2, scale.T = 1, meanlog.T = 0,
  sdlog.T = 1, distr.A = "weibull", shape.A = 1, scale.A = 5,
  p.A = 0.3, Cmax = Inf, fix.seed = NULL)
}
\arguments{
\item{n}{the sample size.}

\item{b}{a numeric vector for true regression coefficients.}

\item{time.dep}{logical, whether there is the time-dependent covariate (only
one indicator function Zv = I(t >= zeta) is supported); the default is
FALSE.}

\item{Zv.depA}{logical, whether the time-dependent covariate \code{Zv}
depends on A^* (the only form supported is Zv = I(t >= zeta + A^*)); the
default is FALSE.}

\item{distr.T}{the baseline survival time (T*) distribution ("exp" or
"weibull").}

\item{shape.T}{the shape parameter for the Weibull distribution of T*.}

\item{scale.T}{the scale parameter for the Weibull distributiof of T*.}

\item{meanlog.T}{the mean for the log-normal distribution of T*.}

\item{sdlog.T}{the sd for the log-normal distribution of T*.}

\item{distr.A}{the baseline truncation time (A*) distribution: either of
\code{"weibull"} (the default), \code{"unif"} (Length-Biased Sampling),
\code{"binomial"} or \code{"dunif"}). Note: If distribution name other than
these are provided, \code{"unif"} will be used.}

\item{shape.A}{the shape parameter for the Weibull distribution of A*.}

\item{scale.A}{the scale parameter for the Weibull distribution of A*.}

\item{p.A}{the success probability for the binomial distribution of A*.}

\item{Cmax}{the upper bound of the uniform distribution of the censoring time
(C).}

\item{fix.seed}{an optional random seed for simulation.}
}
\value{
a list with a data.frame containing the observed survival times
  (\code{Ys}), the observed truncation times (\code{As}), the event indicator
  (\code{Ds}) and the covariates (\code{Zs}); a vector of certain quantiles
  of Ys (\code{taus}); the censoring proportion (\code{PC}) and the
  truncation proportiona (\code{PT}).
}
\description{
Various baseline survival functions and truncation distribution are
available. Censoring rate can be designated through tuning the parameter
\code{Cmax}; \code{Cmas = Inf} means no censoring.
}
\examples{
# With time-invariant covariates only
sim1 = sim.ltrc(n = 100)
head(sim1$dat)
# With one time-dependent covariate
sim2 = sim.ltrc(n = 100, time.dep = TRUE,
         distr.A = "binomial", p.A = 0.8, Cmax = 5)
head(sim2$dat)
# With one time-dependent covariate with dependence on the truncation time
sim3 = sim.ltrc(n = 100, time.dep = TRUE, Zv.depA = TRUE, Cmax = 5)
head(sim3$dat)
}

