% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solve_mcsim.R
\name{solve_mcsim}
\alias{solve_mcsim}
\alias{generate_infile}
\title{Solve PK Model Through MCSim}
\usage{
solve_mcsim(x, mName, infile.name, outfile.name, n = NULL,
  setpoint.name = NULL, params = NULL, vars = NULL, time = NULL,
  condition = NULL)

generate_infile(infile.name, outfile.name, params, vars, time, condition,
  rtol = 1e-06, atol = 1e-09, n = NULL, dist = NULL,
  q.arg = NULL)
}
\arguments{
\item{x}{a list of storing information in the defined sensitivity function.}

\item{mName}{a string giving the name of the model or C file (without extension).}

\item{infile.name}{a character to assign the name of input file.}

\item{outfile.name}{a character to assign the name of output file.}

\item{n}{a numeric to define the sample number.}

\item{setpoint.name}{a character to assign the name of file for parameter matrix.}

\item{params}{a character to assign the testing parameters.}

\item{vars}{a character or a vector to assign the selected output(s).}

\item{time}{a numeric to define the given time point(s).}

\item{condition}{a character to set the specific parameter value in the input file.}

\item{rtol}{an argument passed to the integrator (default 1e-6).}

\item{atol}{an argument passed to the integrator (default 1e-9).}

\item{dist}{a vector of distribution names corresponding to \code{<distribution-name>} in MCSim.}

\item{q.arg}{a list of shape parameters in the sampling distribution (\code{dist}).}
}
\value{
The output result is the 4-dimension array with
c(model evaluations, replications, time-points, output variables).
}
\description{
The \code{solve_mcsim} can solve the differential equations of time-dependent quantity/concentration in different tissues/compartments
through MCSim.
}
\details{
This function allows users to use external data file that assigned in \code{setpoint.name} as parameter matrix.
If you want to use it, be sure to define \code{n} and \code{setpoint.name}.
}
\section{Functions}{
\itemize{
\item \code{solve_mcsim}: Numerical analysis for the PK model by MCSim.

\item \code{generate_infile}: Generate the MCSim input file.
}}

\examples{
\dontrun{
url <- "https://raw.githubusercontent.com/nanhung/pksensi/master/tests/1cpt.model"
destfile <- paste0(getwd(),"/1cpt.model")
download.file(url, destfile)
mName <- "1cpt"
compile_model(mName)

q <- "qunif"
q.arg <- list(list(min = 0.6, max = 1.0),
   list(min = 0.5, max = 1.5),
   list(min = 0.02, max = 0.3),
   list(min = 20, max = 60))

params <- c("Fgutabs","k_a","k_e","V_dist")

set.seed(1234)
x <- rfast99(params = params, n = 200, q = q, q.arg = q.arg, rep = 20)

infile.name <- "example.in"
outfile.name <- "example.csv"
vars <- "C_rest"

t <- seq(from = 0.25, to = 12.25, by = 0.5)

y <- solve_mcsim(x, mName = mName, infile.name = infile.name,
setpoint.name = "setpoint.dat",
outfile.name = outfile.name, params = params, vars = vars, time = t,
condition = "IngDose = 1")

pksim(y)
}

}
