% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkg-installation.R
\name{new_pkg_installation_proposal}
\alias{new_pkg_installation_proposal}
\alias{pkg_installation_proposal}
\title{R6 class for package download and installation.}
\usage{
new_pkg_installation_proposal(refs, config = list(), ...)
}
\arguments{
\item{refs}{Package names or references. See
\link[=pkg_refs]{'Package references'} for the syntax.}

\item{config}{Configuration options, a named list. See
\link[=pkgdepends-config]{'Configuration'}. If it does not include \code{library}, then
\code{.libPaths()[1]} is added as \code{library}.}

\item{...}{Additional arguments, passed to
\href{#method-new}{\code{pkg_installation_proposal$new()}}.}
}
\value{
\code{new_pkg_installation_proposal()} returns a new
\code{pkg_installation_proposal} object.
}
\description{
Download and install R packages, with their dependencies, from various
sources.
}
\details{
\code{new_pkg_installation_proposal()} creates a new object from the
\code{pkg_installation_proposal} class. The advantage of
\code{new_pkg_installation_proposal()} compared to using the
\link{pkg_installation_proposal} constructor directly is that it avoids
making pkgdepends a build time dependency.

Typical workflow to install a set of packages:
\enumerate{
\item Create a \code{pkg_installation_proposal} object with
\code{new_pkg_installation_proposal()}.
\item Resolve all possible dependencies with
\href{#method-resolve}{\code{pkg_installation_proposal$resolve()}}.
\item Solve the package dependencies, to get an installation plan, with
\href{#method-solve}{\code{pkg_installation_proposal$solve()}}.
\item Download all files with
\href{#method-download}{\code{pkg_installation_proposal$download()}}.
\item Install the downloaded files with
\href{#methods-install}{\code{pkg_installation_proposal$install()}}.
}
}
\examples{
\dontshow{if (pkgdepends:::is_online()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontrun{
pdi <- new_pkg_installation_proposal(
  "pak",
  config = list(library = tempfile())
)
pdi

pdi$resolve()
pdi

pdi$solve()
pdi

pdi$download()
pdi
}
\dontshow{\}) # examplesIf}
\dontshow{if (pkgdepends:::is_online()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
pdi <- new_pkg_installation_proposal(
  "r-lib/pkgdepends",
  config = list(library = tempfile()))
pdi
\dontshow{\}) # examplesIf}
\dontshow{if (pkgdepends:::is_online()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
pdi <- new_pkg_installation_proposal("r-lib/pkgdepends")
pdi$get_refs()
\dontshow{\}) # examplesIf}
\dontshow{if (pkgdepends:::is_online()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
pdi <- new_pkg_installation_proposal(
  "pak",
  config = list(library = tempfile())
)
pdi$get_config()
\dontshow{\}) # examplesIf}
\dontshow{if (pkgdepends:::is_online()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontrun{
pdi <- new_pkg_installation_proposal(
  "pak",
  config = list(library = tempfile())
)

pdi$resolve()
pdi$get_resolution()
}
\dontshow{\}) # examplesIf}
\dontshow{if (pkgdepends:::is_online()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontrun{
pdi <- new_pkg_installation_proposal(
  "r-lib/pkgdepends",
  config = list(library = tempfile())
)
pdi$resolve()
pdi$get_resolution()
}
\dontshow{\}) # examplesIf}
\dontshow{if (pkgdepends:::is_online()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
pdi <- new_pkg_installation_proposal(
  "r-lib/pkgdepends",
  config = list(library = tempfile())
)
pdi$get_solve_policy()
pdi$set_solve_policy("upgrade")
pdi$get_solve_policy()
\dontshow{\}) # examplesIf}
\dontshow{if (pkgdepends:::is_online()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
pdi <- new_pkg_installation_proposal(
  "r-lib/pkgdepends",
  config = list(library = tempfile())
)
pdi$get_solve_policy()
pdi$set_solve_policy("upgrade")
pdi$get_solve_policy()
\dontshow{\}) # examplesIf}
\dontshow{if (pkgdepends:::is_online()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontrun{
pdi <- new_pkg_installation_proposal(
  "r-lib/pkgdepends",
  config = list(library = tempfile())
)
pdi$resolve()
pdi$solve()
pdi$get_solution()
}
\dontshow{\}) # examplesIf}
\dontshow{if (pkgdepends:::is_online()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontrun{
pdi <- new_pkg_installation_proposal(
  "r-lib/pkgdepends",
  config = list(library = tempfile())
)
pdi$resolve()
pdi$solve()
pdi$get_solution()
}
\dontshow{\}) # examplesIf}
\dontshow{if (pkgdepends:::is_online()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontrun{
pdi <- new_pkg_installation_proposal(
  "r-lib/pkgdepends",
  config = list(library = tempfile())
)
pdi$resolve()
pdi$solve()
pdi$get_solution()
pdi$show_solution()
}
\dontshow{\}) # examplesIf}
\dontshow{if (pkgdepends:::is_online()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontrun{
# This is an error, because the packages conflict:
pdi <- new_pkg_installation_proposal(
  c("r-lib/pak", "cran::pak"),
  config = list(library = tempfile())
)
pdi$resolve()
pdi$solve()
pdi
# This fails:
# pdi$stop_for_solution_error()
}
\dontshow{\}) # examplesIf}
\dontshow{if (pkgdepends:::is_online()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontrun{
pdi <- new_pkg_installation_proposal(
  "pak",
  config = list(library = tempfile())
)
pdi$resolve()
pdi$solve()
pdi$draw()
}
\dontshow{\}) # examplesIf}
\dontshow{if (pkgdepends:::is_online()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontrun{
pdi <- new_pkg_installation_proposal(
  c("r-lib/pak", "cran::pak"),
  config = list(library = tempfile())
)
pdi$resolve()
pdi$solve()
pdi$download()
pdi$get_downloads()
}
\dontshow{\}) # examplesIf}
\dontshow{if (pkgdepends:::is_online()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontrun{
pdi <- new_pkg_installation_proposal(
  c("r-lib/pak", "cran::pak"),
  config = list(library = tempfile())
)
pdi$resolve()
pdi$solve()
pdi$download()
pdi$get_downloads()
}
\dontshow{\}) # examplesIf}
\dontshow{if (pkgdepends:::is_online()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontrun{
pdi <- new_pkg_installation_proposal(
  "pak",
  config = list(library = tempfile())
)
pdi$resolve()
pdi$solve()
pdi$download()
pdi$get_install_plan()
}
\dontshow{\}) # examplesIf}
\dontshow{if (pkgdepends:::is_online()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Method print
pdi <- new_pkg_installation_proposal(
  "pak",
  config = list(library = tempfile())
)
pdi

pdi$resolve()
pdi

pdi$solve()
pdi

pdi$download()
pdi
\dontshow{\}) # examplesIf}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-pkg_installation_proposal-new}{\code{pkg_installation_proposal$new()}}
\item \href{#method-pkg_installation_proposal-get_refs}{\code{pkg_installation_proposal$get_refs()}}
\item \href{#method-pkg_installation_proposal-get_config}{\code{pkg_installation_proposal$get_config()}}
\item \href{#method-pkg_installation_proposal-resolve}{\code{pkg_installation_proposal$resolve()}}
\item \href{#method-pkg_installation_proposal-async_resolve}{\code{pkg_installation_proposal$async_resolve()}}
\item \href{#method-pkg_installation_proposal-get_resolution}{\code{pkg_installation_proposal$get_resolution()}}
\item \href{#method-pkg_installation_proposal-get_solve_policy}{\code{pkg_installation_proposal$get_solve_policy()}}
\item \href{#method-pkg_installation_proposal-set_solve_policy}{\code{pkg_installation_proposal$set_solve_policy()}}
\item \href{#method-pkg_installation_proposal-solve}{\code{pkg_installation_proposal$solve()}}
\item \href{#method-pkg_installation_proposal-get_solution}{\code{pkg_installation_proposal$get_solution()}}
\item \href{#method-pkg_installation_proposal-show_solution}{\code{pkg_installation_proposal$show_solution()}}
\item \href{#method-pkg_installation_proposal-get_sysreqs}{\code{pkg_installation_proposal$get_sysreqs()}}
\item \href{#method-pkg_installation_proposal-show_sysreqs}{\code{pkg_installation_proposal$show_sysreqs()}}
\item \href{#method-pkg_installation_proposal-stop_for_solution_error}{\code{pkg_installation_proposal$stop_for_solution_error()}}
\item \href{#method-pkg_installation_proposal-create_lockfile}{\code{pkg_installation_proposal$create_lockfile()}}
\item \href{#method-pkg_installation_proposal-draw}{\code{pkg_installation_proposal$draw()}}
\item \href{#method-pkg_installation_proposal-download}{\code{pkg_installation_proposal$download()}}
\item \href{#method-pkg_installation_proposal-async_download}{\code{pkg_installation_proposal$async_download()}}
\item \href{#method-pkg_installation_proposal-get_downloads}{\code{pkg_installation_proposal$get_downloads()}}
\item \href{#method-pkg_installation_proposal-stop_for_download_error}{\code{pkg_installation_proposal$stop_for_download_error()}}
\item \href{#method-pkg_installation_proposal-install}{\code{pkg_installation_proposal$install()}}
\item \href{#method-pkg_installation_proposal-install_sysreqs}{\code{pkg_installation_proposal$install_sysreqs()}}
\item \href{#method-pkg_installation_proposal-get_install_plan}{\code{pkg_installation_proposal$get_install_plan()}}
\item \href{#method-pkg_installation_proposal-format}{\code{pkg_installation_proposal$format()}}
\item \href{#method-pkg_installation_proposal-print}{\code{pkg_installation_proposal$print()}}
\item \href{#method-pkg_installation_proposal-clone}{\code{pkg_installation_proposal$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pkg_installation_proposal-new"></a>}}
\if{latex}{\out{\hypertarget{method-pkg_installation_proposal-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{pkg_installation_proposal} object. Consider using
\code{new_pkg_installation_proposal()} instead of calling the constructor
directly.

The returned object can be used to look up (recursive) dependencies
of R packages from various sources, and then download and install
the package files.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pkg_installation_proposal$new(
  refs,
  config = list(),
  policy = c("lazy", "upgrade"),
  remote_types = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{refs}}{Package names or references. See
\link[=pkg_refs]{'Package references'} for the syntax.}

\item{\code{config}}{Configuration options, a named list. See
\link[=pkgdepends-config]{'Configuration'}. It needs to include the package
library to install to, in \code{library}.}

\item{\code{policy}}{Solution policy. See \link[=pkg_solution]{'The dependency solver'}.}

\item{\code{remote_types}}{Custom remote ref types, this is for advanced
use, and experimental currently.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pkg_installation_proposal-get_refs"></a>}}
\if{latex}{\out{\hypertarget{method-pkg_installation_proposal-get_refs}{}}}
\subsection{Method \code{get_refs()}}{
The package refs that were used to create the
\code{pkg_installation_proposal} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pkg_installation_proposal$get_refs()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A character vector of package refs that were used to create the
\code{pkg_installation_proposal} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pkg_installation_proposal-get_config"></a>}}
\if{latex}{\out{\hypertarget{method-pkg_installation_proposal-get_config}{}}}
\subsection{Method \code{get_config()}}{
Configuration options for the \code{pkg_installation_proposal} object. See
\link[=pkgdepends-config]{'Configuration'} for details.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pkg_installation_proposal$get_config()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Named list. See \link[=pkgdepends-config]{'Configuration'} for the configuration
options.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pkg_installation_proposal-resolve"></a>}}
\if{latex}{\out{\hypertarget{method-pkg_installation_proposal-resolve}{}}}
\subsection{Method \code{resolve()}}{
Resolve the dependencies of the specified package references. This
usually means downloading metadata from CRAN and Bioconductor,
unless already cached, and also from GitHub if GitHub refs were
included, either directly or indirectly. See
\link[=pkg_resolution]{'Dependency resolution'} for details.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pkg_installation_proposal$resolve()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The \code{pkg_installation_proposal} object, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pkg_installation_proposal-async_resolve"></a>}}
\if{latex}{\out{\hypertarget{method-pkg_installation_proposal-async_resolve}{}}}
\subsection{Method \code{async_resolve()}}{
The same as \href{#method-resolve}{\code{resolve()}}, but asynchronous. This
method is for advanced use.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pkg_installation_proposal$async_resolve()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A deferred value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pkg_installation_proposal-get_resolution"></a>}}
\if{latex}{\out{\hypertarget{method-pkg_installation_proposal-get_resolution}{}}}
\subsection{Method \code{get_resolution()}}{
Query the result of the dependency resolution. This method can be
called after \href{#method-resolve}{\code{resolve()}} has completed.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pkg_installation_proposal$get_resolution()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{pkg_resolution_result} object, which is also a data frame. See
\link[=pkg_resolution]{'Dependency resolution'} for its columns.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pkg_installation_proposal-get_solve_policy"></a>}}
\if{latex}{\out{\hypertarget{method-pkg_installation_proposal-get_solve_policy}{}}}
\subsection{Method \code{get_solve_policy()}}{
Returns the current policy of the dependency solver.
See \link[=pkg_solution]{'The dependency solver'} for details.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pkg_installation_proposal$get_solve_policy()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A character vector of length one.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pkg_installation_proposal-set_solve_policy"></a>}}
\if{latex}{\out{\hypertarget{method-pkg_installation_proposal-set_solve_policy}{}}}
\subsection{Method \code{set_solve_policy()}}{
Set the current policy of the dependency solver.
If the object already contains a solution and the new policy is
different than the old policy, then the solution is deleted.
See \link[=pkg_solution]{'The dependency solver'} for details.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pkg_installation_proposal$set_solve_policy(policy = c("lazy", "upgrade"))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{policy}}{Policy to set.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pkg_installation_proposal-solve"></a>}}
\if{latex}{\out{\hypertarget{method-pkg_installation_proposal-solve}{}}}
\subsection{Method \code{solve()}}{
Solve the package dependencies. Out of the resolved dependencies,
it works out a set of packages, that can be installed together to
create a functional installation. The set includes all directly
specified packages, and all required (or suggested, depending on
the configuration) packages as well. It includes every package at
most once. See \link[=pkg_solution]{'The dependency solver'} for details.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pkg_installation_proposal$solve()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The \code{pkg_installation_proposal} object itself, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pkg_installation_proposal-get_solution"></a>}}
\if{latex}{\out{\hypertarget{method-pkg_installation_proposal-get_solution}{}}}
\subsection{Method \code{get_solution()}}{
Returns the solution of the package dependencies.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pkg_installation_proposal$get_solution()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{pkg_solution_result} object, which is a list. See
\link{pkg_solution_result} for details.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pkg_installation_proposal-show_solution"></a>}}
\if{latex}{\out{\hypertarget{method-pkg_installation_proposal-show_solution}{}}}
\subsection{Method \code{show_solution()}}{
Show the solution on the screen.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pkg_installation_proposal$show_solution(key = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{Whether to show the key to the package list annotation.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \link{pkg_solution_result} object, which is a list. See
\link{pkg_solution_result} for details.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pkg_installation_proposal-get_sysreqs"></a>}}
\if{latex}{\out{\hypertarget{method-pkg_installation_proposal-get_sysreqs}{}}}
\subsection{Method \code{get_sysreqs()}}{
Query and categorize system requirements.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pkg_installation_proposal$get_sysreqs()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pkg_installation_proposal-show_sysreqs"></a>}}
\if{latex}{\out{\hypertarget{method-pkg_installation_proposal-show_sysreqs}{}}}
\subsection{Method \code{show_sysreqs()}}{
Show system requirements for the packages in the solution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pkg_installation_proposal$show_sysreqs()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pkg_installation_proposal-stop_for_solution_error"></a>}}
\if{latex}{\out{\hypertarget{method-pkg_installation_proposal-stop_for_solution_error}{}}}
\subsection{Method \code{stop_for_solution_error()}}{
Error if the dependency solver failed to find a consistent set of
packages that can be installed together.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pkg_installation_proposal$stop_for_solution_error()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pkg_installation_proposal-create_lockfile"></a>}}
\if{latex}{\out{\hypertarget{method-pkg_installation_proposal-create_lockfile}{}}}
\subsection{Method \code{create_lockfile()}}{
Create a lock file that contains the information to perform
the installation later, possibly in another R session.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pkg_installation_proposal$create_lockfile(path = "pkg.lock", version = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Name of the lock file. The default is \code{pkg.lock} in the
current working directory.}

\item{\code{version}}{Only version 1 is supported currently.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Note, since the URLs of CRAN and most CRAN-like repositories change
over time, in practice you cannot perform the plan of the lock file
\emph{much} later. For example, binary packages of older package version
are removed, and won't be found.

Similarly, for \verb{url::} remote types, the URL might hold an updated
version of the package, compared to when the lock file was created.
Should this happen, pkgdepends prints a warning, but it will try
to continue the installation. The installation might fail if the
updated package has different (e.g. new) dependencies.

Currently the intended use case of lock files in on CI systems, to
facilitate caching. The (hash of the) lock file provides a good key
for caching systems.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pkg_installation_proposal-draw"></a>}}
\if{latex}{\out{\hypertarget{method-pkg_installation_proposal-draw}{}}}
\subsection{Method \code{draw()}}{
Draw a tree of package dependencies. It returns a \code{tree} object, see
\code{\link[cli:tree]{cli::tree()}}. Printing this object prints the dependency tree to the
screen.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pkg_installation_proposal$draw()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \code{tree} object from the cli package, see \code{\link[cli:tree]{cli::tree()}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pkg_installation_proposal-download"></a>}}
\if{latex}{\out{\hypertarget{method-pkg_installation_proposal-download}{}}}
\subsection{Method \code{download()}}{
Download all packages that are part of the solution. It uses the
package cache in the pkgcache package by default, to avoid downloads
if possible.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pkg_installation_proposal$download()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The \code{pkg_installation_proposal} object itself, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pkg_installation_proposal-async_download"></a>}}
\if{latex}{\out{\hypertarget{method-pkg_installation_proposal-async_download}{}}}
\subsection{Method \code{async_download()}}{
The same as \href{#method-download}{\code{download()}}, but asynchronous.
This method is for advanced use.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pkg_installation_proposal$async_download()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A deferred value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pkg_installation_proposal-get_downloads"></a>}}
\if{latex}{\out{\hypertarget{method-pkg_installation_proposal-get_downloads}{}}}
\subsection{Method \code{get_downloads()}}{
Returns the summary of the package downloads.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pkg_installation_proposal$get_downloads()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{pkg_download_result} object, which is a list. See
\link{pkg_download_result} for details.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pkg_installation_proposal-stop_for_download_error"></a>}}
\if{latex}{\out{\hypertarget{method-pkg_installation_proposal-stop_for_download_error}{}}}
\subsection{Method \code{stop_for_download_error()}}{
Throw and error if the some of the downloads have failed for the
most recent
\href{#method-download}{\code{pkg_installation_proposal$download()}} call.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pkg_installation_proposal$stop_for_download_error()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pkg_installation_proposal-install"></a>}}
\if{latex}{\out{\hypertarget{method-pkg_installation_proposal-install}{}}}
\subsection{Method \code{install()}}{
Install the downloaded packages. It calls \code{\link[=install_package_plan]{install_package_plan()}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pkg_installation_proposal$install()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The return value of \code{\link[=install_package_plan]{install_package_plan()}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pkg_installation_proposal-install_sysreqs"></a>}}
\if{latex}{\out{\hypertarget{method-pkg_installation_proposal-install_sysreqs}{}}}
\subsection{Method \code{install_sysreqs()}}{
Install system requirements. It does nothing if system requirements
are turned off.
Create an installation plan for the downloaded packages.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pkg_installation_proposal$install_sysreqs()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pkg_installation_proposal-get_install_plan"></a>}}
\if{latex}{\out{\hypertarget{method-pkg_installation_proposal-get_install_plan}{}}}
\subsection{Method \code{get_install_plan()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pkg_installation_proposal$get_install_plan()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
An installation plan, see \link[=install_plans]{'Installation plans'} for
the format.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pkg_installation_proposal-format"></a>}}
\if{latex}{\out{\hypertarget{method-pkg_installation_proposal-format}{}}}
\subsection{Method \code{format()}}{
Format a \code{pkg_installation_proposal} object, typically for printing.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pkg_installation_proposal$format(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{not used currently.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A character vector, each element should be a line in the printout.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pkg_installation_proposal-print"></a>}}
\if{latex}{\out{\hypertarget{method-pkg_installation_proposal-print}{}}}
\subsection{Method \code{print()}}{
Prints a \code{pkg_installation_proposal} object to the screen.

The printout includes:
\itemize{
\item The package refs.
\item The policy of the dependency solver.
\item Whether the object has the solved dependencies.
\item Whether the solution had errors.
\item Whether the object has downloads.
\item Whether the downloads had errors.
\item Advice on which methods to call next.
}

See the example below.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pkg_installation_proposal$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{not used currently.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{pkg_installation_proposal} object itself, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pkg_installation_proposal-clone"></a>}}
\if{latex}{\out{\hypertarget{method-pkg_installation_proposal-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pkg_installation_proposal$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
