% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_alignment_with_std_nsm_from_params.R
\name{sim_alignment_with_std_nsm_from_params}
\alias{sim_alignment_with_std_nsm_from_params}
\title{Create an alignment with a standard site model}
\usage{
sim_alignment_with_std_nsm_from_params(phylogeny, alignment_params)
}
\arguments{
\item{phylogeny}{a phylogeny of class \link[ape]{phylo}}

\item{alignment_params}{parameters to simulate an alignment,
as can be created by \link{create_alignment_params}}
}
\value{
an alignment of type \code{DNAbin}
}
\description{
Create an alignment with a standard site model
}
\examples{
phylogeny <- ape::read.tree(text = "((A:1, B:1):1, C:2);")
alignment_params <- create_alignment_params(
  root_sequence = "aaaa",
  sim_tral_fun = get_sim_tral_with_std_nsm_fun(
    mutation_rate = 0.1
  )
)
alignment <- sim_alignment_with_std_nsm_from_params(
  phylogeny = phylogeny,
  alignment_params = alignment_params
)
check_alignment(alignment)
}
\seealso{
use \link{sim_alignment_with_std_nsm} to simulate an alignment
directlt from a mutation rate, root sequence and site model
}
\author{
Richèl J.C. Bilderbeek
}
