% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pir_runs.R
\name{pir_runs}
\alias{pir_runs}
\title{Do multiple \link{pirouette} runs}
\usage{
pir_runs(phylogenies, pir_paramses)
}
\arguments{
\item{phylogenies}{a list of phylogenies,
each phylogeny being of class \link[ape]{phylo}}

\item{pir_paramses}{a list of \link[pirouette]{pirouette} parameters,
each element created by \link{create_pir_params}.}
}
\value{
a list of \link{pir_run} outputs.
}
\description{
This is a simple convenience functions: supply as much phylogenies
as \link{pirouette} parameter sets. For each phylogeny-parameters
pair, \link{pir_run} is called.
}
\examples{
if (beautier::is_on_ci() && beastier::is_beast2_installed()) {

  pir_paramses <- list()
  pir_paramses[[1]] <- create_test_pir_params()
  pir_paramses[[2]] <- create_test_pir_params()

  phylogenies <- list()
  phylogenies[[1]] <- ape::read.tree(text = "((A:2, B:2):1, C:3);")
  phylogenies[[2]] <- ape::read.tree(text = "((A:1, B:1):2, C:3);")

  pir_outs <- pir_runs(
    phylogenies = phylogenies,
    pir_paramses = pir_paramses
  )
  for (pir_out in pir_outs) {
    check_pir_out(pir_out)
  }
}
}
\seealso{
\itemize{
  \item Use \link{pir_run} for a single \link{pirouette} run.
  \item Use \link{pir_plots} to plot the output of this function.
  \item Use \link{check_pir_out} on each list element, to check its validity.
}
}
\author{
Richèl J.C. Bilderbeek
}
