% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_experiments_candidates_have_same_mcmcs.R
\name{check_experiments_candidates_have_same_mcmcs}
\alias{check_experiments_candidates_have_same_mcmcs}
\title{Check that the candidate experiments have a same MCMC}
\usage{
check_experiments_candidates_have_same_mcmcs(experiments)
}
\arguments{
\item{experiments}{a list of one or more \link{pirouette} experiments,
as can be created by \link{create_experiment}. If more than one experiment
is provided and a "generative" experiment is part of them, the "generative"
one has to be the first in the list. See also:
\itemize{
  \item Use \link{check_experiments} to check the list of
    experiments for validity
  \item Use \link{create_all_experiments} to create experiments with
    all combinations of tree model, clock model and tree priors
  \item Use \link{create_all_bd_experiments} to create experiments
    with all combinations of tree model, clock model and tree priors,
    except for only using birth-death tree priors
  \item Use \link{create_all_coal_experiments} to create all experiments
    with all combinations of tree model, clock model and tree priors,
    except for only coalescent tree priors
  \item Use \link{shorten_experiments} to shorten the run time
    of the list of experiments
}}
}
\value{
nothing
}
\description{
If all the candidates share a same MCMC, they share the same
tracelog and treelog. In this way, one can predict where the parameter
estimates (the trace) and posterior trees are written to, as only the
best candidate will run.
}
\author{
Richèl J.C. Bilderbeek
}
