% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_experiments.R
\name{check_experiments}
\alias{check_experiments}
\title{Checks if the argument is a list of one or more \link{pirouette} experiments.}
\usage{
check_experiments(experiments)
}
\arguments{
\item{experiments}{a list of one or more \link{pirouette} experiments,
as can be created by \link{create_experiment}. If more than one experiment
is provided and a "generative" experiment is part of them, the "generative"
one has to be the first in the list. See also:
\itemize{
  \item Use \link{check_experiments} to check the list of
    experiments for validity
  \item Use \link{create_all_experiments} to create experiments with
    all combinations of tree model, clock model and tree priors
  \item Use \link{create_all_bd_experiments} to create experiments
    with all combinations of tree model, clock model and tree priors,
    except for only using birth-death tree priors
  \item Use \link{create_all_coal_experiments} to create all experiments
    with all combinations of tree model, clock model and tree priors,
    except for only coalescent tree priors
  \item Use \link{shorten_experiments} to shorten the run time
    of the list of experiments
}}
}
\value{
nothing. Will \link{stop} if not
}
\description{
Will \link{stop} if not.
A valid \link{pirouette} experiment
can be created by \link{create_experiment}.
}
\examples{
if (beautier::is_on_ci()) {

  check_experiments(list(create_test_experiment()))

  if (rappdirs::app_dir()$os != "win") {
    experiments <- list(
      create_test_experiment(),
      create_test_cand_experiment()
    )
    # Experiments must have different inference models
    experiments[[1]]$inference_model$site_model <-
      beautier::create_gtr_site_model()

    check_experiments(experiments)
  }
}
}
\seealso{
Use \link{check_experiment} to check if an object
  is one valid experiment
}
\author{
Richèl J.C. Bilderbeek
}
