% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_alignment_n_taxa.R
\name{get_alignment_n_taxa}
\alias{get_alignment_n_taxa}
\title{Get the number of taxa of an alignment}
\usage{
get_alignment_n_taxa(alignment, verbose = FALSE)
}
\arguments{
\item{alignment}{a DNA alignment, of class \link[ape]{DNAbin}}

\item{verbose}{if TRUE, show more output}
}
\value{
the number of taxa
}
\description{
Get the number of taxa of an alignment
}
\examples{
get_alignment_n_taxa(
  alignment = ape::as.DNAbin(
    x = list(species_1 = strsplit("aaaa", split = "")[[1]])
  )
)
}
\author{
Richèl J.C. Bilderbeek
}
