% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psi_mpa.R
\name{psi_mpa}
\alias{psi_mpa}
\title{Megapascals to pounds per square inch}
\usage{
psi_mpa(x)
}
\arguments{
\item{x}{pressure (stress) measured in \emph{megapascals}. [\emph{MPa}].
Type: \code{\link{assert_double}}.}
}
\value{
pressure (stress) in \emph{pounds per square inch},
 [\emph{PSI}]. Type: \code{\link{assert_double}}.
}
\description{
Convert pressure (stress) measured in \href{https://en.wikipedia.org/wiki/Pascal_(unit)}{megapascals} (MPa)
 to \href{https://en.wikipedia.org/wiki/Pounds_per_square_inch}{pounds per square inch} (PSI)
}
\examples{
 psi_mpa(c(6.89475728e-3, 1))
 # [1] 1.0000 145.0377 # [PSI]

}
\seealso{
\code{\link{mpa_psi}} for converting \emph{pounds per square inch} to \emph{megapascals}

Other utils: 
\code{\link{inch_mm}()},
\code{\link{kgf_mpa}()},
\code{\link{mm_inch}()},
\code{\link{mpa_kgf}()},
\code{\link{mpa_psi}()}
}
\concept{utils}
