% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pin_info.R
\name{pin_info}
\alias{pin_info}
\title{Retrieve pin metadata (legacy API)}
\usage{
pin_info(
  name,
  board = NULL,
  extended = TRUE,
  metadata = TRUE,
  signature = FALSE,
  ...
)
}
\arguments{
\item{name}{The exact name of the pin to match when searching.}

\item{board}{The board name used to find the pin.}

\item{extended}{Should additional board-specific information be shown?}

\item{metadata}{Should additional pin-specific information be shown?}

\item{signature}{Should a signature to identify this pin be shown?}

\item{...}{Additional parameters.}
}
\description{
Retrieve metadata for pins in legacy boards.
}
\examples{
\dontshow{if (rlang::is_installed("filelock")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# old API
board_register_local(cache = tempfile())
pin(mtcars)
pin_info("mtcars", "local")

# new API
board <- board_temp()
board \%>\% pin_write(mtcars)
board \%>\% pin_meta("mtcars")
\dontshow{\}) # examplesIf}
}
