% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/board_s3.R
\name{board_s3}
\alias{board_s3}
\title{Use an S3 bucket as a board}
\usage{
board_s3(
  bucket,
  prefix = NULL,
  versioned = TRUE,
  access_key = NULL,
  secret_access_key = NULL,
  session_token = NULL,
  credential_expiration = NULL,
  profile = NULL,
  region = NULL,
  endpoint = NULL,
  cache = NULL
)
}
\arguments{
\item{bucket}{Bucket name. You can only write to an existing bucket.}

\item{prefix}{Prefix within this bucket that this board will occupy.
You can use this to maintain multiple independent pin boards within
a single S3 bucket. Will typically end with \code{/} to take advantage of
S3's directory-like handling.}

\item{versioned}{Should this board be registered with support for versions?}

\item{access_key, secret_access_key, session_token, credential_expiration}{Manually control authentication. See documentation below for details.}

\item{profile}{Role to use from AWS shared credentials/config file.}

\item{region}{AWS region. If not specified, will be read from \code{AWS_REGION},
or AWS config file.}

\item{endpoint}{Endpoint to use; usually generated automatically for AWS
from \code{region}. For MinIO, use the full URL (including scheme like
\verb{https://}) of your MinIO endpoint.}

\item{cache}{Cache path. Every board requires a local cache to avoid
downloading files multiple times. The default stores in a standard
cache location for your operating system, but you can override if needed.}
}
\description{
Pin data to an S3 bucket, such as on Amazon's S3 service or MinIO, using the
paws.storage package.
}
\section{Authentication}{
\code{board_s3()} is powered by the paws package which provides a wide range
of authentication options, as documented at
\url{https://github.com/paws-r/paws/blob/main/docs/credentials.md}.
In brief, there are four main options that are tried in order:
\itemize{
\item The \code{access_key} and \code{secret_access_key} arguments to this function.
If you have a temporary session token, you'll also need to supply
\code{session_token} and \code{credential_expiration}.
(Not recommended since your \code{secret_access_key} will be recorded
in \code{.Rhistory})
\item The \code{AWS_ACCESS_KEY_ID} and \code{AWS_SECRET_ACCESS_KEY} env vars.
(And \code{AWS_SESSION_TOKEN} and \code{AWS_CREDENTIAL_EXPIRATION} env vars if you
have a temporary session token)
\item The AWS shared credential file, \verb{~/.aws/credentials}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{[profile-name]
aws_access_key_id=your AWS access key
aws_secret_access_key=your AWS secret key
}\if{html}{\out{</div>}}

The "default" profile will be used if you don't supply the access key
and secret access key as described above. Otherwise you can use the
\code{profile} argument to use a profile of your choice.
\item Automatic authentication from EC2 instance or container IAM role.
}

See the paws documentation for more unusual options including getting
credentials from a command line process, picking a role when running inside
an EC2 instance, using a role from another profile, and using multifactor
authentication.
}

\section{Details}{
\itemize{
\item The functions in pins do not create a new bucket. You can create
a new bucket from R with \link[paws.storage:s3_create_bucket]{paws}.
\item Some functions like \code{\link[=pin_list]{pin_list()}} will work for an S3 board, but don't
return useful output.
\item You can pass arguments for \link[paws.storage:s3_put_object]{paws.storage::s3_put_object} such as \code{Tagging}
and \code{ServerSideEncryption} through the dots of \code{pin_write()}.
\item \code{board_s3()} is powered by the paws.storage package, which is a
suggested dependency of pins (not required for pins in general). If
you run into errors when deploying content to a server like
\url{https://www.shinyapps.io} or \href{https://posit.co/products/enterprise/connect/}{Connect},
add \code{library(paws.storage)} to your app or document for \href{https://docs.posit.co/connect/user/troubleshooting/#render-missing-r-package}{automatic dependency discovery}.
}
}

\examples{
\dontrun{
board <- board_s3("pins-test-hadley", region = "us-east-2")
board \%>\% pin_write(mtcars)
board \%>\% pin_read("mtcars")

# A prefix allows you to have multiple independent boards in the same pin.
board_sales <- board_s3("company-pins", prefix = "sales/")
board_marketing <- board_s3("company-pins", prefix = "marketing/")
# You can make the hierarchy arbitrarily deep.

# Pass arguments like `Tagging` through the dots of `pin_write`:
board \%>\% pin_write(mtcars, Tagging = "key1=value1&key2=value2")

}
}
