% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/piglet.R
\name{piglet}
\alias{piglet}
\title{The Program for Ig clusters (PIgLET) package}
\description{
PIgLET is a suite of computational tools that improves genotype inference and downstream AIRR-seq data analysis.
The package as two main tools. The first is Allele Clusters, this tool is designed to reduce the ambiguity within the IGHV alleles. The ambiguity
is caused by duplicated or similar alleles which are shared among different genes.
The second tool is an allele based genotype, that determined the presence of an allele based on
a threshold derived from a naive population.
}
\section{Allele Similarity Cluster}{

This section provides the functions that support the main tool of creating the allele similarity cluster form
an IGHV germline set.

\itemize{
\item  \link{inferAlleleClusters}:      The main function of the section to create the allele clusters based on a germline set.
\item  \link{ighvDistance}:             Calculate the distance between IGHV aligned germline sequences.
\item  \link{ighvClust}:                Hierarchical clustering of the distance matrix from \code{ighvDistance}.
\item  \link{generateReferenceSet}:     Generate the allele clusters reference set.
\item  \link{plotAlleleCluster}:        Plots the Hierarchical clustering.
\item  \link{artificialFRW1Germline}:   Artificially create an IGHV reference set with framework1 (FWR1) primers.
}
}

\section{Allele based genotype}{

This section provides the functions to infer the IGHV genotype using
the allele based method and the allele clusters thresholds

\itemize{
\item  \link{inferGenotypeAllele}:      Infer the IGHV genotype using the allele based method.
\item  \link{assignAlleleClusters}:     Renames the v allele calls based on the new allele clusters.
\item  \link{germlineASC}:              Converts IGHV germline set to ASC germline set.
\item  \link{recentAlleleClusters}:     Download the most recent version of the allele clusters table archive from zenodo.
\item  \link{extractASCTable}:          Extracts the allele cluster table from the zenodo archive file.
\item  \link{zenodoArchive}:            An R6 object to query the zenodo api.
}
}

\references{
\enumerate{
\item  ##
}
}
