% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allele_genotype.R
\name{assignAlleleClusters}
\alias{assignAlleleClusters}
\title{Assign allele similarity clusters}
\usage{
assignAlleleClusters(data, alleleClusterTable, v_call = "v_call")
}
\arguments{
\item{data}{data.frame in AIRR format, containing V allele calls from a single subject and the sample IMGT-gapped V(D)J sequences under seq.}

\item{alleleClusterTable}{A data.frame of the allele clusters new annotations relative to the original reference set. See details.}

\item{v_call}{name of the V allele call column. Default is \code{v_call}}
}
\value{
A modified input \code{data.frame} with the new assigned
}
\description{
\code{assignAlleleClusters} uses the allele clusters annotation to change the preliminary allele
assignments to the new annotations before inferring a genotype.
}
\examples{


# preferably obtain the latest ASC cluster table
# asc_archive <- recentAlleleClusters(doi="10.5281/zenodo.7429773", get_file = TRUE)

# allele_cluster_table <- extractASCTable(archive_file = asc_archive)

# example allele similarity cluster table
data(allele_cluster_table)

# loading TIgGER AIRR-seq b cell data
data <- tigger::AIRRDb

asc_data <- assignAlleleClusters(data, allele_cluster_table)


}
