% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cropmarkGrob.R
\name{grid.cropmark}
\alias{grid.cropmark}
\alias{cropmarkGrob}
\title{Crop Mark Grob}
\usage{
cropmarkGrob(
  ...,
  piece_side = "tile_back",
  suit = NA,
  rank = NA,
  cfg = getOption("piecepackr.cfg", pp_cfg()),
  x = unit(0.5, "npc"),
  y = unit(0.5, "npc"),
  angle = 0,
  width = NA,
  height = NA,
  scale = 1,
  default.units = "npc",
  envir = getOption("piecepackr.envir"),
  name = NULL,
  gp = NULL,
  vp = NULL,
  bleed = unit(0.125, "in"),
  cm_select = "12345678",
  cm_width = unit(0.25, "mm"),
  cm_length = unit(0.125, "in")
)

grid.cropmark(..., draw = TRUE)
}
\arguments{
\item{...}{\code{cropmarkGrob()} ignores; \code{grid.cropmark()} passes to \code{cropmarkGrob()}.}

\item{piece_side}{A string with piece and side separated by a underscore e.g. "coin_face"}

\item{suit}{Number of suit (starting from 1).}

\item{rank}{Number of rank (starting from 1)}

\item{cfg}{Piecepack configuration list or \code{pp_cfg} object,
a list of \code{pp_cfg} objects,
or a character vector referring to names in \code{envir}
or a character vector referring to object names that
can be retrieved by \code{base::dynGet()}.}

\item{x}{Where to place piece on x axis of viewport}

\item{y}{Where to place piece on y axis of viewport}

\item{angle}{Angle (on xy plane) to draw piece at}

\item{width}{Width of piece}

\item{height}{Height of piece}

\item{scale}{Multiplicative scaling factor to apply to width, height, and depth.}

\item{default.units}{A string indicating the default units to use if
'x', 'y', 'width', and/or 'height' are only given as numeric vectors.}

\item{envir}{Environment (or named list) containing configuration list(s).}

\item{name}{A character identifier (for grid)}

\item{gp}{An object of class \dQuote{gpar}.}

\item{vp}{A \code{grid} viewport object (or \code{NULL}).}

\item{bleed}{Bleed zone size to assume:
\itemize{
\item{If \code{bleed} is a \code{\link[grid:unit]{grid::unit()}} simply use it}
\item{If \code{bleed} is numeric then convert via \code{grid::unit(bleed, default.units)}}
\item{If \code{bleed} is \code{TRUE} assume 1/8 inch bleed zone size}
\item{If \code{bleed} is \code{FALSE} assume 0 inch bleed zone size}
}}

\item{cm_select}{A string of integers from "1" to "8" indicating which
crop marks to draw.  "1" represents the top right crop mark
then we proceeding clockwise to "8" which represents the
top left crop mark.
Default "12345678" draws all eight crop marks.}

\item{cm_width}{Width of crop mark.}

\item{cm_length}{Length of crop mark.}

\item{draw}{A logical value indicating whether graphics output should be produced.}
}
\value{
A grid grob.
}
\description{
\code{grid.cropmark()} draws \dQuote{crop marks} to the active graphics device.
\code{cropmarkGrob()} is its grid grob counterpart.
Intended for use in adding crop marks around
game pieces in print-and-play layouts.
}
\examples{
if (require("grid")) {
  cfg <- pp_cfg(list(mat_color = "pink", mat_width=0.05, border_color=NA))
  grid.newpage()
  df <- data.frame(piece_side = "tile_face", suit = 2, rank = 2,
                   x = 2, y = 2, angle = 0,
                   stringsAsFactors = FALSE)
  pmap_piece(df, grid.cropmark, cfg = cfg, default.units = "in")
  pmap_piece(df, grid.piece, cfg = cfg, default.units = "in", bleed=TRUE)

  grid.newpage()
  df <- data.frame(piece_side = "coin_back", suit = 2, rank = 2,
                   x = 2, y = 2, angle = 0,
                   stringsAsFactors = FALSE)
  pmap_piece(df, grid.cropmark, cfg = cfg, default.units = "in", bleed=TRUE)
  pmap_piece(df, grid.piece, cfg = cfg, default.units = "in", bleed=TRUE)
}
}
