% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cut.piar_aggregation_structure.R
\name{cut.piar_aggregation_structure}
\alias{cut.piar_aggregation_structure}
\title{Cut an aggregation structure}
\usage{
\method{cut}{piar_aggregation_structure}(x, level, ..., na.rm = FALSE, upper = TRUE)
}
\arguments{
\item{x}{A price index aggregation structure, as made by
\code{\link[=aggregation_structure]{aggregation_structure()}}.}

\item{level}{A positive integer, or something that can be coerced into one,
giving the level at which to cut \code{x}.}

\item{...}{Not currently used.}

\item{na.rm}{Should missing values be removed when aggregating the
weights? By default, missing values are not removed.}

\item{upper}{Keep only the part of \code{x} above \code{level} (the default);
otherwise, return the part of \code{x} below \code{level}.}
}
\value{
A price index aggregation structure.
}
\description{
Keep only the part of an aggregation structure above or below a certain
level.
}
\examples{
# A simple aggregation structure
#            1
#      |-----+-----|
#      11          12
#  |---+---|       |
#  111     112     121
#  (1)     (3)     (4)

aggregation_weights <- data.frame(
  level1 = c("1", "1", "1"),
  level2 = c("11", "11", "12"),
  ea     = c("111", "112", "121"),
  weight = c(1, 3, 4)
)

pias <- aggregation_structure(
  aggregation_weights[1:3],
  weights = aggregation_weights[[4]]
)

# Turn it into
#            1
#      |-----+-----|
#      11          12
#     (4)         (4)

cut(pias, 2)

}
\seealso{
Other aggregation structure methods: 
\code{\link{as.matrix.piar_aggregation_structure}()},
\code{\link{levels.piar_aggregation_structure}()},
\code{\link{update.piar_aggregation_structure}()},
\code{\link{weights.piar_aggregation_structure}()}
}
\concept{aggregation structure methods}
