% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/bmi.R
\name{ideal_weight_Straub}
\alias{ideal_weight_Straub}
\title{ideal weight for child per Straub}
\source{
\url{http://www.ncbi.nlm.nih.gov/pubmed/6823980}
}
\usage{
ideal_weight_Straub(heightm, age.years = NULL, age.months = NULL,
  age.days = NULL, warn = FALSE)
}
\arguments{
\item{heightm}{single numeric, height in meters}

\item{age.years}{numeric vector, age(s) in years}

\item{age.months}{numeric vector, age(s) in months}

\item{age.days}{numeric vector, age(s) in days}

\item{warn}{single logical, if TRUE, will produce warnings for very
unrealistic physical measurements, and other minor problems}
}
\description{
http://www.ncbi.nlm.nih.gov/pubmed/6823980 2.396e0.01863(ht),
  where height is in cm. There is an argument for using another package to
  capture durations, of which age is a special case. However, I am resisting
  bringing in external dependencies, and for almost all use-cases I can
  imagine, the age will be captured as a single number of one type, not a mix
  of types. Note that gender does not appear to be important in this
  relationship.

  See package AGD for CDC growth chart data.
}
\examples{
# will warn if given age is not in validate range from publication:
\dontrun{
  ideal_weight_child(0.5, age.years = 0, warn = TRUE)
  ideal_weight_child(0.8, age.months = 11, warn = TRUE)
  ideal_weight_child(0.5, age.days = 25, warn = TRUE)
}
  ideal_weight_child(0.5, age.days = 25, warn = FALSE)
  ideal_weight_child(1, age.years = 2)
  ideal_weight_child(0.75, age.months = 15)
}

