% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-classes.R
\docType{class}
\name{ClstrArc-class}
\alias{ClstrArc-class}
\alias{ClstrArc-method}
\alias{as.character,ClstrArc-method}
\alias{show,ClstrArc-method}
\alias{print,ClstrArc-method}
\alias{str,ClstrArc-method}
\alias{summary,ClstrArc-method}
\alias{[[,ClstrArc,character-method}
\alias{[,ClstrArc,character,missing,missing-method}
\title{Cluster record archive}
\usage{
\S4method{as.character}{ClstrArc}(x)

\S4method{show}{ClstrArc}(object)

\S4method{print}{ClstrArc}(x)

\S4method{str}{ClstrArc}(object, max.level = 2L, ...)

\S4method{summary}{ClstrArc}(object)

\S4method{[[}{ClstrArc,character}(x, i)

\S4method{[}{ClstrArc,character,missing,missing}(x, i, j, ..., drop = TRUE)
}
\arguments{
\item{x}{\code{ClstrArc} object}

\item{object}{\code{ClstrArc} object}

\item{max.level}{Maximum level of nesting for str()}

\item{...}{Further arguments for str()}

\item{i}{cid(s)}

\item{j}{Unused}

\item{drop}{Unused}
}
\description{
Multiple cluster records.
}
\section{Slots}{

\describe{
\item{\code{ids}}{Vector of cluster record IDs}

\item{\code{clstrs}}{List of ClstrArc named by ID}
}}

\examples{
data('aotus')
clstrarc <- aotus@clstrs
# this is a ClstrArc object
# it contains cluster records
show(clstrarc)
# you can access its different data slots with @
clstrarc@ids     # unique cluster ID
clstrarc@clstrs  # list of cluster records
# access cluster records [[
(clstrarc[[clstrarc@ids[[1]]]])  # first cluster record
# generate new cluster archives with [
(clstrarc[clstrarc@ids[1:10]])  # first 10 clusters
}
\seealso{
Other run-public: \code{\link{ClstrRec-class}},
  \code{\link{Phylota-class}}, \code{\link{SeqArc-class}},
  \code{\link{SeqRec-class}}, \code{\link{TaxDict-class}},
  \code{\link{TaxRec-class}}, \code{\link{clusters2_run}},
  \code{\link{clusters_run}},
  \code{\link{parameters_reset}}, \code{\link{reset}},
  \code{\link{restart}}, \code{\link{run}},
  \code{\link{setup}}, \code{\link{taxise_run}}
}
