% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phyloSim.R
\name{phyloSim}
\alias{phyloSim}
\title{Simulate the behaviour of phylogenetic signal statistics with a given phylogeny}
\usage{
phyloSim(tree, methods = c("all", "I", "Cmean", "Lambda", "K", "K.star"),
  nsim = 99, reps = 999, W = NULL, model = "BM", pb = TRUE)
}
\arguments{
\item{tree}{a \code{phylo}, \code{phylo4} or \code{phylo4d} object.}

\item{methods}{a character vector giving the methods to compute phylogenetic signal (see Details).}

\item{nsim}{a numeric value. Number of simulated traits at each step in the gradient.}

\item{reps}{a numeric value. Number of repetitions for the estimation of p.values with randomization.}

\item{W}{an optional matrix of phylogenetic weights to compute Moran's I. By default the matrix
is computed with the function \code{\link[adephylo]{proxTips}} with patristic distances.}

\item{model}{the model to use for traits simulation (only "\code{BM}", default, is available).}

\item{pb}{a logical. Should a progress bar be printed? (default \code{TRUE}).}
}
\value{
An object of class \code{phylosim}.
}
\description{
This function simulates different phylogenetic signal statistics
for a given phylogenetic tree along a gradient of Brownian Motion influence.
}
\details{
By default, the \code{methods} argument is set to "\code{all}" and all the available methods are used.
The user can specify which method(s) to use. Possible values are
"\code{I}", "\code{Cmean}", "\code{Lambda}", "\code{K}" and "\code{K.star}",
see \code{\link{phyloSignal}} for further details.
}
\examples{
\dontrun{
data(navic)
psim <- phyloSim(navic)
plot(psim)
plot.phylosim(psim, what = "pval", stacked.methods = TRUE)
}

}
\seealso{
\code{\link{phyloSimSignal}}.
}
