% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statgentools.R
\name{pref_sample}
\alias{pref_sample}
\title{Sample preferentially}
\usage{
pref_sample(f, lim = c(0, 1), c = 1, beta = 1, upper = NULL,
  grid.len = 1000)
}
\arguments{
\item{f}{function to be sampled from preferentially.}

\item{lim}{lower and upper sampling bounds. Defaults to c(0,1).}

\item{c}{numeric constant of proportionality for intensity. Defaults to 1.}

\item{beta}{numeric power to which f is raised for intensity. Defaults to 1.}

\item{upper}{numeric upper bound for function between limits defined by lim.
Used in thinning algorithm.}

\item{grid.len}{integer if upper is undefined, automatically evaluates f at
grid.len points between min(lim) and max(lim) to find upper bound.}
}
\description{
Sample values from an inhomogeneous Poisson process with intensity
  c*f(t)^beta.
}

