% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nodeImbFrac.R
\name{nodeImbFrac}
\alias{nodeImbFrac}
\title{Fraction of nodes with given imbalance}
\usage{
nodeImbFrac(tree, threshold)
}
\arguments{
\item{tree}{a tree of class \code{phylo} or \code{phylo4}. The tree should be binary and rooted; if not it will be coerced into a binary rooted tree using multi2di, if possible.}

\item{threshold}{a threshold value for node imbalance.}
}
\value{
For any internal node, the function \code{\link{nodeImb}} gives the number of tip descendants of each of the node's descending branches. The function \code{nodeImbFrac} returns the fraction of internal nodes where the difference between these numbers is greater than or equal to the threshold.
}
\description{
Calculate the fraction of internal nodes with an imbalance greater than or equal to a given threshold.
}
\examples{
## Find the fraction of internal nodes with an imbalance of 5 or more, 
## in a random tree with 20 tips:
tree <- rtree(20)
plot(tree)
nodeImbFrac(tree,threshold=5) 

}
\seealso{
\code{\link{nodeImb}}
}
\author{
Michelle Kendall \email{michelle.louise.kendall@gmail.com}
}
