\name{modelAnalysis}
\alias{modelAnalysis}
\alias{modelSummary}
\alias{modelCreate}
\alias{treeListSummary}

\title{
Model Analysis
}
\description{
A collection of functions to summarize the topological properties of trees generated by a model or other large groups of trees. Note that the examples section is quite detailed and many be useful to read. Some of them use the library \code{ggplot2} which will need to be installed seperately. More examples like this can be found in \code{exampleSummary}.
}
\usage{
modelSummary(model,topList,n,loadingBar=TRUE)
modelCreate(model,n,loadingBar=FALSE)
treeListSummary(treeList,topList,loadingBar=TRUE)
}
\arguments{
\item{model}{
A function with no inputs which results in an object of class \code{phylo4}. For example, \code{model = function() {rtree(50)}} is allowed. It is intended that there be some randomness in the model.
}
\item{topList}{
This is a list of functions. Each function in the list acts on an object of class \code{phylo4} and returns a number - which is intended to be a topological property of the tree.
}
\item{n}{
An integer specifying the number of trees create.
}
\item{loadingBar}{
A Boolean. If true, it results in the number trees evaluated so far being printed as each tree is evaluated. This gives some indication of how long the function will take.
}
\item{treeList}{
A list where the elements of the list are cobjects of class \code{phylo4}.
}
}
\details{
\code{modelSummary} generates some trees using the model created and returns a data frame with the topological summaries in \code{topList}. The rows correspond to the trees generated and the columns to the different summaries.

\code{modelCreate} creates a list of \emph{n} trees using the model specified. Note that \code{loadingbar} is \code{FALSE} by default here as most \code{model}'s are likely to be quick.

\code{treeListSummary} performs the functions in \code{topList} on a list of trees. It returns a data frame where the rows correspond to the trees and the columns to the different summaries.
}
\value{
\item{modelSummary}{
A data frame with the rows corresponding to the different trees and the columns to the result of the topological summaries in \code{topList}
}
\item{modelCreate}{
A list of \emph{n} objects of class \code{phylo4}
}
\item{treeListSummary}{
A data frame with the rows corresponding to the different trees and the columns to the result of the topological summaries in \code{topList}
}
}
\author{
Michael Boyd
}
\seealso{
\code{\link{treeAnalysis}} and \code{link{configurations}} for some ideas of which functions to add to \code{topList}.

\code{\link{exampleSummary}} for more examples of plots.
}
\examples{
## Create a function to test
maxLadd <- function(tree) {max(ladderNums(tree))}

## Create a model 
## NOTE THE USE OF 'as'
bdModel <- function() {as(rlineage(0.5,0.1,Tmax=6),'phylo4')}

\dontrun{
## A simple example of modelSummary
modelSummary(function(){rtree4(50)},topList=c(avgLadder,sackin),n=10)

## Another example using the created model and function
modelSummary(bdModel,topList=c(maxLadd,sackin),n=10,loadingBar=FALSE)

## Create a list of trees for more detailed analysis
bdTrees <- modelCreate(bdModel,10)

## Select a number of topological summaries to calculate
summaries <- c(avgLadder,maxLadd,sackin,function(tree){nConfig(tree,2)})

## Calculate these summaries for the trees in question
bdSummary <- treeListSummary(bdTrees,summaries)
names(bdSummary) <- c('avgLadder','maxLadd','Sackin','Cherries')

### I WILL NOW ILLUSTRATE SOME USES OF THE PACKAGE
### THESE METHODS USE LIBARY ggplot2
### IT WILL NEED TO BE SEPERATELY INSTALLED IF YOU WISH TO USE IT

# Initialize a plot
p <- ggplot(data=bdSummary)

# Simple bar plot
p + geom_bar(aes(avgLadder),binwidth=0.1)

# Simple scatter plot
p + geom_point(aes(x=Sackin,y=Cherries))

### See exampleSummary for more examples of plots
}
}
