% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/infectorsets.R
\name{infectorsets}
\alias{infectorsets}
\title{Sampled infectors for each host in a phybreak-object.}
\usage{
infectorsets(phybreak.object, which.hosts = "all", percentile = 0.95,
  minsupport = 0, samplesize = Inf, infector.name = TRUE,
  support = c("proportion", "count"))
}
\arguments{
\item{phybreak.object}{An object of class \code{phybreak}.}

\item{which.hosts}{A vector with hosts (positions in the dataset), or \code{"all"} for all hosts.}

\item{percentile}{Return infectors ordered by support, until a cumulative support indicated by \code{percentile},
support measured by proportion (value between 0 and 1).}

\item{minsupport}{Only return infectors with more support than \code{minsupport}. Values in the range [0,1] are 
interpreted as support in \code{"proportion"} of posterior samples, values > 1 as code{"count"} of posterior 
samples.}

\item{samplesize}{The number of samples to include (taken from the tail of the MCMC-chain).}

\item{infector.name}{Whether to return the names of the infectors, or their position in the dataset.}

\item{support}{Whether to return the support (= posterior probability) for each infector as a \code{"proportion"} 
or as a \code{"count"} of posterior trees in which that transmission link or transmission cluster is present.}
}
\value{
A named list with \code{data.frame}s, each with a vector of infectors and a vector of supports.
}
\description{
The function takes a \code{phybreak}-object containing MCMC-samples, and returns for each host 
  a table with posterior infectors, with support per infector.
}
\examples{
#First build a phybreak-object containing samples.
simulation <- sim.phybreak(obsize = 5)
MCMCstate <- phybreak(data = simulation$sequences, times = simulation$sample.times)
MCMCstate <- burnin.phybreak(MCMCstate, ncycles = 20)
MCMCstate <- sample.phybreak(MCMCstate, nsample = 50, thin = 2)

infectorsets(MCMCstate)
}
\references{
\href{http://dx.doi.org/10.1371/journal.pcbi.1005495}{Klinkenberg et al. (2017)} Simultaneous 
  inference of phylogenetic and transmission trees in infectious disease outbreaks. 
  \emph{PLoS Comput Biol}, \strong{13}(5): e1005495.
}
\author{
Don Klinkenberg \email{don@xs4all.nl}
}
