% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_lists.R
\name{merge_lists}
\alias{merge_lists}
\title{Compare and merge two lists}
\usage{
merge_lists(a, b)
}
\arguments{
\item{a}{the 1st list}

\item{b}{the 2nd list}
}
\value{
a list containing the merged configuration
}
\description{
compare two lists using the first list as a base;
  update the values of the first list if the second one has
  different values; add varibles to the first if they doe not
  exist in the first list.
}
\examples{
  a <- "https://github.com/phuse-org/phuse-scripts/raw/master"
  b <- "development/R/scripts"
  c <- "Draw_Dist_R.yml"
  f1 <- paste(a,b,c, sep = '/')
  dr <- resolve(system.file("examples", package = "phuse"), "02_display")
  f2 <- paste(dr, "www", "Draw_Dist_R.yml", sep = '/')
  r1 <- read_yml(f1)
  r2 <- read_yml(f2)
  r3 <- merge_lists(r1, r2)
}
\author{
Hanming Tu
}
