% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/led_brands.r
\docType{data}
\name{led_brands}
\alias{led_brands}
\alias{Agilent_leds}
\alias{HueyJann_leds}
\alias{LedEngin_leds}
\alias{Ledguhon_leds}
\alias{LCFOCUS_leds}
\alias{Marktech_leds}
\alias{CREE_leds}
\alias{Epileds_leds}
\alias{Epistar_leds}
\alias{SeoulSemicon_leds}
\alias{Bridgelux_leds}
\alias{Nichia_leds}
\alias{Norlux_leds}
\alias{Osram_leds}
\alias{QuantumDevices_leds}
\alias{Roithner_leds}
\alias{Weili_leds}
\alias{TaoYuan_leds}
\alias{Luminus_leds}
\alias{Samsung_leds}
\title{Spectral data for LEDs from different suppliers}
\format{
A vector of character strings.

An object of class \code{character} of length 7.

An object of class \code{character} of length 2.

An object of class \code{character} of length 15.

An object of class \code{character} of length 2.

An object of class \code{character} of length 4.

An object of class \code{character} of length 1.

An object of class \code{character} of length 1.

An object of class \code{character} of length 8.

An object of class \code{character} of length 1.

An object of class \code{character} of length 3.

An object of class \code{character} of length 2.

An object of class \code{character} of length 9.

An object of class \code{character} of length 4.

An object of class \code{character} of length 3.

An object of class \code{character} of length 4.

An object of class \code{character} of length 15.

An object of class \code{character} of length 4.

An object of class \code{character} of length 1.

An object of class \code{character} of length 1.

An object of class \code{character} of length 1.
}
\usage{
led_brands

Agilent_leds

HueyJann_leds

LedEngin_leds

Ledguhon_leds

LCFOCUS_leds

Marktech_leds

CREE_leds

Epileds_leds

Epistar_leds

SeoulSemicon_leds

Bridgelux_leds

Nichia_leds

Norlux_leds

Osram_leds

QuantumDevices_leds

Roithner_leds

Weili_leds

TaoYuan_leds

Luminus_leds

Samsung_leds
}
\description{
The collection of spectra \code{\link{leds.mspct}} contains spectra for light
emitting diodes (LEDs) from several different suppliers. The character
vectors described here contain the names of the spectra for LEDs from each
supplier/brand to facilitate their extraction from the collection. One
additional vector, \code{led_brands} contains the names of the brands as used
in the names of the spectra in the collection.
}
\details{
As described for the individual brands, ownership of brands and companies has
changed over the years through take-overs, mergers and sales of company
divisions. Even when brand names have changed it has been the norm for
electronic components that component type codes are maintained unchanged. In
contrast to some integrated circuits, exact replacement types from multiple
suppliers are not available for LEDs.
}
\section{Agilent/Hewlett Packard}{

The character vector \code{Agilent_leds} contains the names of the spectra to
facilitate their extraction from the collection.The division of Hewlett
Packard which supplied these LEDs became part of Agilent when this division
spin-off the mother company. More recently the electronic components division
of Agilent became Avago Technologies for a while. Currently, BROADCOM
supplies some of these LEDs or similar improved types.
}

\section{Huey Jann}{

Huey Jann was a Taiwanese supplier of high power LED arrays. It is no longer
in business.
}

\section{LED Engin}{

Led Engin was an independent supplier of power LEDs in low thermal resistance
ceramic substrate packages. It is now part of Osram.
}

\section{LEDGUHON}{

These LEDs where bought from AliExpress. They are assembled using
Bridgelux chips by Guangzhou Juhong Optoelectronics Co., Ltd., China.
}

\section{LCFOCUS}{

These LEDs where bought from LCFOCUS official store at AliExpress. They are 
assembled  LCFOCUS TECH, Shenzhen China.
}

\section{Marktech}{

Marktech Optoelectronics is a distributor and supplier of LEDs from the 
U.S.A. that sells VIS and UV emitting LEDs.
}

\section{CREE}{

The former LED products group of Cree is now Cree LED (U.S.A.) and a part of
SGH.
}

\section{Epileds}{
 
EPI LEDS Co., Ltd. (Taiwan) is devoted to the R & D,
design, manufacture and sales of blue, green, red, and white light LED
wafers and chips.
}

\section{Epistar}{
 
EPISTAR Corporation (Taiwan).
}

\section{Seoul Semiconductors}{
 
Seoul Semiconductor (Korea) supplies LEDs, including SunLike white LEDs 
using 'phosphor' technology from Toshiba (Japan). Seoul Viosys supplies
UV LEDs based on an agreement with SETi (U.S.A.).
}

\section{Bridgelux}{
 
Bridgelux, Inc. (U.S.A.) is a supplier of LEDs partnering with Epistar and
Kaistar for the manufacture of their LEDs.
}

\section{Nichia}{
 
With 24% global market share, Nichia (Japan) is the largest LED manufacturer
in the world and inventor of the blue (and also white) light emitting diodes.
The company was already an important supplier of 'phosphors' before the
invention of the white LEDs based on blue-emitting LED chips.

Some of the Nichia LEDs we measured were assembled into arrays of the series
names SmartArray and LinearZ from LUMITRONIX (Germany), and/or supplied by
LEDRISE Ltd. (Hong Kong, Germany and Romania) .
}

\section{Norlux}{
 
Norlux is now part of Thomas Research Products. The LEDs we measured are
some of the earliest COB designs from early 1990's. Each COB containing 90 
LED chips. (Norlux is no longer in bussiness.)
}

\section{Osram}{
 
ams-OSRAM International GmbH (Germany) produces LEDS and various light and
other sensors. Current trade name for LEDs is Osram Opto Semiconductors.
Osram has recently become owner of Led Engin, whose LEDs are listed 
separately in this pacakge. LEDs supplied under the LED Engin brand differ
mostly in the packages' thermal properties and contact layout.
}

\section{Quantum Devices}{
 
Quantum Devices (U.S.A.) sold in the past both individual LEDs and luminaires.
They were in the late 1980's and early 1990's the supplier of choice for LEDs
emitting in the far-red region of the spectrum. The company still exists but 
no longer sells LEDs.
}

\section{Roithner LaserTechnik}{
 
Roithner LaserTechnik is a distributor and reseller of LEDs, LED arrays and
lasers. They have a very extensive catalogue covering almost all wavelengths
for which LEDs are manufactured. Many of the LEDs are sold under new codes
as they are retested and in some cases individual characterization data
provided. For example some of short UV LEDs sold are from SETi.
}

\section{Shenzhen Weili}{
 
Leds Global and Shenzhen Weili are trade names of the same supplier of LEDs and LED
arrays. They sell both standard types and also assemble customized arrays
upon request. Customized arrays may have up to twelve independent channels
and vary in power output from 10 W to 300 W.
}

\section{Tao Yuan}{

TaoYuan Electron (Hong Kong and China) is a supplier of LEDs and LED arrays.
}

\section{Luminus}{

Luminus Devices (USA) is a supplier of SMD LEDs and COB LEDs as components.
}

\section{Samsung}{

Samsung LEDs (South Korea) is a supplier of SMD LEDs and COB LEDs as components.
}

\examples{
led_brands
Agilent_leds

}
\references{
\url{https://www.broadcom.com/products/leds-and-displays/}

\url{https://www.osram.us/ledengin/}

\url{https://www.ledguhon.com/}

\url{https://marktechopto.com/}

\url{https://cree-led.com/}

\url{https://www.epileds.com.tw/en/}

\url{https://www.epistar.com/}

\url{http://www.seoulsemicon.com/en/}

\url{https://www.bridgelux.com/}

\url{https://www.nichia.co.jp/en/product/led.html}

\url{https://www.osram-os.com/}

\url{https://www.roithner-laser.com/} and 
\url{http://www.s-et.com/en/}

\url{https://www.leds-global.com/}

\url{https://www.ledwv.com/en/}

\url{https://www.luminus.com/}

\url{https://www.samsung.com/led/}
}
\seealso{
\code{\link{leds.mspct}}
}
\concept{manufacturers}
\keyword{datasets}
