% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prod.spectra.r
\name{prod_spectra}
\alias{prod_spectra}
\title{Multiply two spectra, even if the wavelengths values differ}
\usage{
prod_spectra(w.length1, w.length2 = NULL, s.irrad1, s.irrad2,
  trim = "union", na.rm = FALSE)
}
\arguments{
\item{w.length1}{numeric vector of wavelength (nm).}

\item{w.length2}{numeric vector of wavelength (nm).}

\item{s.irrad1}{a numeric vector of spectral values.}

\item{s.irrad2}{a numeric vector of spectral values.}

\item{trim}{a character string with value "union" or "intersection".}

\item{na.rm}{a logical value, if TRUE, not the default, NAs in the input are
replaced with zeros.}
}
\value{
a dataframe with two numeric variables \item{w.length}{A numeric
  vector with the wavelengths (nm) obtained by "fusing" w.length1 and
  w.length2. w.length contains all the unique vales, sorted in ascending
  order.} \item{s.irrad}{A numeric vector with the sum of the two spectral
  values at each wavelength.}
}
\description{
The wavelength vectors of the two spectra are merged, and the missing
spectral values are calculated by interpolation. After this, the two spectral
values at each wavelength are added.
}
\details{
If trim=="union" spectral values are calculated for the whole range
  of wavelengths covered by at least one of the input spectra, and missing
  values are set in each input spectrum to zero before addition. If
  trim=="intersection" then the range of wavelengths covered by both input
  spectra is returned, and the non-overlapping regions discarded. If
  w.length2==NULL, it is assumed that both spectra are measured at the same
  wavelengths, and a simple addition is used, ensuring fast calculation.
}
\examples{

head(sun.data)
square.sun.data <-
  with(sun.data, prod_spectra(w.length, w.length, s.e.irrad, s.e.irrad))
head(square.sun.data)
tail(square.sun.data)

}
\seealso{
Other low-level functions operating on numeric vectors.: \code{\link{as_energy}},
  \code{\link{as_quantum_mol}},
  \code{\link{calc_multipliers}},
  \code{\link{div_spectra}},
  \code{\link{energy_irradiance}},
  \code{\link{energy_ratio}}, \code{\link{insert_hinges}},
  \code{\link{integrate_xy}},
  \code{\link{interpolate_spectrum}},
  \code{\link{irradiance}}, \code{\link{l_insert_hinges}},
  \code{\link{oper_spectra}},
  \code{\link{photon_irradiance}},
  \code{\link{photon_ratio}},
  \code{\link{photons_energy_ratio}},
  \code{\link{s_e_irrad2rgb}},
  \code{\link{split_energy_irradiance}},
  \code{\link{split_photon_irradiance}},
  \code{\link{subt_spectra}}, \code{\link{sum_spectra}},
  \code{\link{trim_tails}}, \code{\link{v_insert_hinges}},
  \code{\link{v_replace_hinges}}
}
\concept{low-level functions operating on numeric vectors.}
