% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.operators.r
\name{T2A}
\alias{T2A}
\alias{T2A.default}
\alias{T2A.filter_spct}
\alias{T2A.filter_mspct}
\title{Convert transmittance into absorbance.}
\usage{
T2A(x, action, byref, clean, ...)

\method{T2A}{default}(x, action = NULL, byref = FALSE, clean = TRUE, ...)

\method{T2A}{filter_spct}(x, action = "add", byref = FALSE, clean = TRUE,
  ...)

\method{T2A}{filter_mspct}(x, action = "add", byref = FALSE, clean = TRUE,
  ..., .parallel = FALSE, .paropts = NULL)
}
\arguments{
\item{x}{an R object}

\item{action}{character Allowed values "replace" and "add"}

\item{byref}{logical indicating if new object will be created by reference or by copy of x}

\item{clean}{logical replace off-boundary values before conversion}

\item{...}{not used in current version}

\item{.parallel}{if TRUE, apply function in parallel, using parallel backend
provided by foreach}

\item{.paropts}{a list of additional options passed into the foreach function
when parallel computation is enabled. This is important if (for example)
your code relies on external data or packages: use the .export and
.packages arguments to supply them so that all cluster nodes have the
correct environment set up for computing.}
}
\description{
Function that converts transmittance (fraction) into absorbance (a.u.).
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default method for generic function

\item \code{filter_spct}: Method for filter spectra

\item \code{filter_mspct}: Method for collections of filter spectra
}}

\seealso{
Other quantity conversion functions: \code{\link{A2T}},
  \code{\link{T2Afr}}, \code{\link{T2T}},
  \code{\link{as_quantum}},
  \code{\link{e2qmol_multipliers}},
  \code{\link{e2quantum_multipliers}}, \code{\link{e2q}},
  \code{\link{q2e}}
}
