% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/head-tail.R
\name{head_tail}
\alias{head_tail}
\alias{head_tail.default}
\alias{head_tail.data.frame}
\alias{head_tail.matrix}
\alias{head_tail.function}
\alias{head_tail.table}
\alias{head_tail.ftable}
\title{Return the First and Last Part of an Object}
\usage{
head_tail(x, ...)

\method{head_tail}{default}(x, n = 3L, ...)

\method{head_tail}{data.frame}(x, n = 3L, ...)

\method{head_tail}{matrix}(x, n = 3L, ...)

\method{head_tail}{function}(x, n = 6L, ...)

\method{head_tail}{table}(x, n = 6L, ...)

\method{head_tail}{ftable}(x, n = 6L, ...)
}
\arguments{
\item{x}{an object.}

\item{...}{arguments to be passed to or from other methods.}

\item{n}{a single integer. If positive, half the size for the resulting
object: number of elements for a vector (including lists), rows for a
matrix or data frame or lines for a function, to be retained from each
end. If negative, all but the n last and n first number of elements of x.}
}
\value{
An object (usually) like x but generally smaller. For ftable objects
 \code{x}, a transformed \code{format(x)}.
}
\description{
Returns the first and last parts of a spectrum, dataframe, vector, function,
table or ftable.
}
\details{
The value returned by head_tail() is equivalent to row binding the
 the values returned by head() and tail(), although not implemented in this
 way. The same specializations as defined in package 'utils' for head() and
 tail() have been implemented.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: 

\item \code{data.frame}: 

\item \code{matrix}: 

\item \code{function}: 

\item \code{table}: 

\item \code{ftable}: 
}}

\note{
For some types of input, like functions, the output may be confusing,
 however, we have opted for consistency with existing functions. The code
 is in part a revision of that of head() and tail() from package utils. I
 have been missing this method especially when checking spectral data, as
 both ends are of interest.

\code{head_tail()} methods for function, table and ftable classes, are
  wrappers for head() method.
}
\examples{

head_tail(letters)
head_tail(letters, n = -6L)
head_tail(freeny.x, n = 10L)
head_tail(freeny.y)

head_tail(stats::ftable(Titanic))

}
\seealso{
\code{\link[utils]{head}}, and compare the examples and the values
 returned to the examples below.
}
\keyword{internal}
