% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.metadata.r
\name{setWhatMeasured}
\alias{setWhatMeasured}
\alias{what_measured<-}
\alias{setWhatMeasured.default}
\alias{setWhatMeasured.generic_spct}
\alias{setWhatMeasured.summary_generic_spct}
\alias{setWhatMeasured.data.frame}
\alias{setWhatMeasured.generic_mspct}
\title{Set the "what.measured" attribute}
\usage{
setWhatMeasured(x, ...)

what_measured(x) <- value

\method{setWhatMeasured}{default}(x, what.measured, ...)

\method{setWhatMeasured}{generic_spct}(x, what.measured, ...)

\method{setWhatMeasured}{summary_generic_spct}(x, what.measured, ...)

\method{setWhatMeasured}{data.frame}(x, what.measured, ...)

\method{setWhatMeasured}{generic_mspct}(x, what.measured, ...)
}
\arguments{
\item{x}{a generic_spct object}

\item{...}{Allows use of additional arguments in methods for other classes.}

\item{what.measured, value}{a list}
}
\value{
x
}
\description{
Function to set by reference the "what.measured" attribute  of an existing
generic_spct, generic_mspct, summary_generic_spct, data.frame or a
derived-class object.
}
\section{Methods (by class)}{
\itemize{
\item \code{setWhatMeasured(default)}: default

\item \code{setWhatMeasured(generic_spct)}: generic_spct

\item \code{setWhatMeasured(summary_generic_spct)}: summary_generic_spct

\item \code{setWhatMeasured(data.frame)}: data.frame

\item \code{setWhatMeasured(generic_mspct)}: generic_mspct

}}
\note{
This function alters x itself by reference and in addition
  returns x invisibly. If x is not a generic_spct object, x is not
  modified.
}
\examples{
my.spct <- sun.spct
what_measured(my.spct)
what_measured(my.spct) <- "Sun"
what_measured(my.spct)

}
\seealso{
Other measurement metadata functions: 
\code{\link{add_attr2tb}()},
\code{\link{getFilterProperties}()},
\code{\link{getHowMeasured}()},
\code{\link{getInstrDesc}()},
\code{\link{getInstrSettings}()},
\code{\link{getSoluteProperties}()},
\code{\link{getWhatMeasured}()},
\code{\link{getWhenMeasured}()},
\code{\link{getWhereMeasured}()},
\code{\link{get_attributes}()},
\code{\link{isValidInstrDesc}()},
\code{\link{isValidInstrSettings}()},
\code{\link{select_spct_attributes}()},
\code{\link{setFilterProperties}()},
\code{\link{setHowMeasured}()},
\code{\link{setInstrDesc}()},
\code{\link{setInstrSettings}()},
\code{\link{setSoluteProperties}()},
\code{\link{setWhenMeasured}()},
\code{\link{setWhereMeasured}()},
\code{\link{spct_attr2tb}()},
\code{\link{spct_metadata}()},
\code{\link{subset_attributes}()},
\code{\link{trimInstrDesc}()},
\code{\link{trimInstrSettings}()}
}
\concept{measurement metadata functions}
