% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_presentation.R
\name{create_presentation}
\alias{create_presentation}
\title{Creates a presentation}
\usage{
create_presentation(
  stimuli,
  translations = "",
  external = NULL,
  font_size = 50,
  output_dir,
  output_format = "html",
  output_file = "stimuli_presentation",
  render = TRUE
)
}
\arguments{
\item{stimuli}{the vector of stimuli (obligatory). Can be a path to an image.}

\item{translations}{the vector of translations (optional)}

\item{external}{the vector with the indices of external images}

\item{font_size}{font size in px (50, by default)}

\item{output_dir}{the output directory for the rendered file}

\item{output_format}{the string that difine the R Markdown output format:
"html" (by default) or "pptx"}

\item{output_file}{the name of the result presentation file
(by default stimuli_presentation)}

\item{render}{the logical argument, if \code{TRUE} render the created R
Markdown presentation to the \code{output_dir} folder, otherwise returns the
path to the temporary file with a Rmd file.}
}
\value{
If \code{render} is \code{FALSE}, the function returns a path to the
temporary file. If \code{render} is \code{TRUE}, there is no output in a
function.
}
\description{
Creates an html or powerpoint presentation in a working directory from list
of words and translations.
\href{https://ropensci.github.io/phonfieldwork/additional/first_example.html}{Here}
is an example of such presentation.
}
\examples{
create_presentation(
  stimuli = c("rzeka", "drzewo"),
  translations = c("river", "tree"),
  render = FALSE
)

# with image
create_presentation(
  stimuli = c(
    "rzeka", "drzewo",
    system.file("extdata", "r-logo.png",
      package = "phonfieldwork"
    )
  ),
  translations = c("river", "tree", ""),
  external = 3,
  render = FALSE
)
}
\author{
George Moroz <agricolamz@gmail.com>
}
