\name{rmvtnorm}
\alias{rmvtnorm}
\title{
Random multivariate normal variables
}
\description{
Draw vectors from a multivariate normal distribution.
}
\usage{
rmvtnorm (n = 1, k = 2, means = rep (0, k), sigma = diag (k))
}
\arguments{
  \item{n }{ the number of vectors to be drawn.} 
  \item{k }{ the dimension of the vectors to be drawn.} 
  \item{means }{ a vector of means, one for each dimension.} 
  \item{sigma }{ the covariance matrix of the distribution. If a number between 0 and 1 is provided, this is assumed to be the correlation parameter for a bivariate standard normal distribution.} 
}
\details{
If means and sigma are not specified, a standard normal distribution is assumed along every dimensions, and dimensions are assumed to be uncorrelated. 
}
\value{
A matrix with rows equal to n and columns equal to k, where each row indicates a single observation.
}
\author{
Santiago Barreda <sbarreda@ualberta.ca>
}
\examples{

## Examples of draws from different bivariate normal distributions
## and standard deviation ellipses drawn to fit them.
par (mfrow = c(2,2))
draws = rmvtnorm (n = 1000, k = 2, sigma = .3)
plot (draws)
sdellipse (draws, stdev = 3, lwd = 3, col = 2)

draws = rmvtnorm (n = 1000, k = 2, sigma = -.3)
plot (draws)
sdellipse (draws, stdev = 3, lwd = 3, col = 2)

draws = rmvtnorm (n = 1000, k = 2, sigma = -.7)
plot (draws)
sdellipse (draws, stdev = 3, lwd = 3, col = 2)

draws = rmvtnorm (n = 1000, k = 2, sigma = .7)
plot (draws)
sdellipse (draws, stdev = 3, lwd = 3, col = 2)

}





