% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phoenix_endocrine.R
\name{phoenix_endocrine}
\alias{phoenix_endocrine}
\title{Phoenix Endocrine Score}
\usage{
phoenix_endocrine(glucose = NA_real_, data = parent.frame(), ...)
}
\arguments{
\item{glucose}{numeric vector; blood glucose measured in mg/dL}

\item{data}{a \code{list}, \code{data.frame}, or \code{environment} containing the input vectors}

\item{...}{pass through}
}
\value{
a integer vector with values 0 or 1

As with all other Phoenix organ system scores, missing values in the data set
will map to a score of zero - this is consistent with the development of the
criteria.
}
\description{
Assess the Phoenix endocrine organ dysfunction score.  This score is not part
of the Phoenix score, only part of the Phoenix-8 score.
}
\section{Phoenix Endocrine Scoring}{
 The endocrine dysfunction score is based
on blood glucose with one point for levels < 50 mg/dL or > 150 mg/dL.
}

\examples{

# using the example sepsis data set
# recall glucose is expected to have units of mg/dL

endo_example       <- sepsis[c("pid", "glucose")]
endo_example$score <- phoenix_endocrine(glucose, data = sepsis)
endo_example

# example data set to get all the possible endocrine scores
# recall glucose is expected to have units of mg/dL

DF <- data.frame(glc = c(NA, 12, 50, 55, 100, 150, 178))
phoenix_endocrine(glucose = glc, data = DF)

}
\references{
See reference details in \code{\link{phoenix-package}} or by calling
\code{citation('phoenix')}.
}
\seealso{
\itemize{ \item \code{\link{phoenix}} for generating the diagnostic
Phoenix Sepsis score based on the four organ systems: \itemize{ \item
\code{\link{phoenix_cardiovascular}}, \item
\code{\link{phoenix_coagulation}}, \item \code{\link{phoenix_neurologic}},
\item \code{\link{phoenix_respiratory}}, } \item \code{\link{phoenix8}} for
generating the diagnostic Phoenix 8 Sepsis criteria based on the four organ
systems noted above and \itemize{ \item \code{\link{phoenix_endocrine}},
\item \code{\link{phoenix_immunologic}}, \item \code{\link{phoenix_renal}},
\item \code{\link{phoenix_hepatic}}, } }

\code{vignette('phoenix')} for more details and examples.
}
