test_that("Functions run without any error or message", {
  skip_on_cran()
  expect_silent(get_arrests())
  expect_silent(get_arrests(geography = "citywide"))
  expect_silent(get_arrests(geography = "police_district"))
  expect_silent(get_arrests(geography = "zip_code"))
  expect_silent(get_arrests(geography = "census_tract"))

  expect_silent(get_bail())
  expect_silent(get_bail(geography = "citywide"))
  expect_silent(get_bail(geography = "police_district"))
  expect_silent(get_bail(geography = "zip_code"))
  expect_silent(get_bail(geography = "census_tract"))

  expect_silent(get_case_length())
  expect_silent(get_case_length(geography = "citywide"))
  expect_silent(get_case_length(geography = "police_district"))
  expect_silent(get_case_length(geography = "zip_code"))
  expect_silent(get_case_length(geography = "census_tract"))

  expect_silent(get_case_outcomes())
  expect_silent(get_case_outcomes(geography = "citywide"))
  expect_silent(get_case_outcomes(geography = "police_district"))
  expect_silent(get_case_outcomes(geography = "zip_code"))
  expect_silent(get_case_outcomes(geography = "census_tract"))

  expect_silent(get_charges())
  expect_silent(get_charges(geography = "citywide"))
  expect_silent(get_charges(geography = "police_district"))
  expect_silent(get_charges(geography = "zip_code"))
  expect_silent(get_charges(geography = "census_tract"))

  expect_silent(get_future_years_of_incarceration())
  expect_silent(get_future_years_of_incarceration(geography = "citywide"))
  expect_silent(get_future_years_of_incarceration(geography = "police_district"))
  expect_silent(get_future_years_of_incarceration(geography = "zip_code"))
  expect_silent(get_future_years_of_incarceration(geography = "census_tract"))

  expect_silent(get_future_years_of_supervision())
  expect_silent(get_future_years_of_supervision(geography = "citywide"))
  expect_silent(get_future_years_of_supervision(geography = "police_district"))
  expect_silent(get_future_years_of_supervision(geography = "zip_code"))
  expect_silent(get_future_years_of_supervision(geography = "census_tract"))

  expect_silent(get_summary_arrests())
  expect_silent(get_summary_arrests(geography = "citywide"))
  expect_silent(get_summary_arrests(geography = "police_district"))
  expect_silent(get_summary_arrests(geography = "zip_code"))
  expect_silent(get_summary_arrests(geography = "census_tract"))

  expect_silent(get_summary_case_length())
  expect_silent(get_summary_case_length(geography = "citywide"))
  expect_silent(get_summary_case_length(geography = "police_district"))
  expect_silent(get_summary_case_length(geography = "zip_code"))
  expect_silent(get_summary_case_length(geography = "census_tract"))

  expect_silent(get_summary_case_outcomes())
  expect_silent(get_summary_case_outcomes(geography = "citywide"))
  expect_silent(get_summary_case_outcomes(geography = "police_district"))
  expect_silent(get_summary_case_outcomes(geography = "zip_code"))
  expect_silent(get_summary_case_outcomes(geography = "census_tract"))

  expect_silent(get_summary_charges())
  expect_silent(get_summary_charges(geography = "citywide"))
  expect_silent(get_summary_charges(geography = "police_district"))
  expect_silent(get_summary_charges(geography = "zip_code"))
  expect_silent(get_summary_charges(geography = "census_tract"))

})


test_that("Expect error with non-accepted input is inputted", {

  expect_error(get_arrests(NA))
  expect_error(get_arrests(7))
  expect_error(get_arrests(mtcars))
  expect_error(get_arrests(mtcars$mpg))
  expect_error(get_arrests(c("geography", "citywide")))
  expect_error(get_arrests("CITYwide"))
  expect_error(get_arrests(c("citywide", NA)))
  expect_error(get_arrests(mean()))
  expect_error(get_arrests(c("citywide", NA, NULL)))
  expect_error(get_arrests(c("citywide", "police_district", "census_tract", "zip_code")))
  expect_error(get_arrests(wdasfgh))

  expect_error(get_bail(NA))
  expect_error(get_bail(7))
  expect_error(get_bail(mtcars))
  expect_error(get_bail(mtcars$mpg))
  expect_error(get_bail(c("geography", "citywide")))
  expect_error(get_bail("CITYwide"))
  expect_error(get_bail(c("citywide", NA)))
  expect_error(get_bail(mean()))
  expect_error(get_bail(c("citywide", NA, NULL)))
  expect_error(get_bail(c("citywide", "police_district", "census_tract", "zip_code")))
  expect_error(get_bail(wdasfgh))

  expect_error(get_case_length(NA))
  expect_error(get_case_length(7))
  expect_error(get_case_length(mtcars))
  expect_error(get_case_length(mtcars$mpg))
  expect_error(get_case_length(c("geography", "citywide")))
  expect_error(get_case_length("CITYwide"))
  expect_error(get_case_length(c("citywide", NA)))
  expect_error(get_case_length(mean()))
  expect_error(get_case_length(c("citywide", NA, NULL)))
  expect_error(get_case_length(c("citywide", "police_district", "census_tract", "zip_code")))
  expect_error(get_case_length(wdasfgh))

  expect_error(get_case_outcomes(NA))
  expect_error(get_case_outcomes(7))
  expect_error(get_case_outcomes(mtcars))
  expect_error(get_case_outcomes(mtcars$mpg))
  expect_error(get_case_outcomes(c("geography", "citywide")))
  expect_error(get_case_outcomes("CITYwide"))
  expect_error(get_case_outcomes(c("citywide", NA)))
  expect_error(get_case_outcomes(mean()))
  expect_error(get_case_outcomes(c("citywide", NA, NULL)))
  expect_error(get_case_outcomes(c("citywide", "police_district", "census_tract", "zip_code")))
  expect_error(get_case_outcomes(wdasfgh))

  expect_error(get_charges(NA))
  expect_error(get_charges(7))
  expect_error(get_charges(mtcars))
  expect_error(get_charges(mtcars$mpg))
  expect_error(get_charges(c("geography", "citywide")))
  expect_error(get_charges("CITYwide"))
  expect_error(get_charges(c("citywide", NA)))
  expect_error(get_charges(mean()))
  expect_error(get_charges(c("citywide", NA, NULL)))
  expect_error(get_charges(c("citywide", "police_district", "census_tract", "zip_code")))
  expect_error(get_charges(wdasfgh))

  expect_error(get_future_years_of_incarceration(NA))
  expect_error(get_future_years_of_incarceration(7))
  expect_error(get_future_years_of_incarceration(mtcars))
  expect_error(get_future_years_of_incarceration(mtcars$mpg))
  expect_error(get_future_years_of_incarceration(c("geography", "citywide")))
  expect_error(get_future_years_of_incarceration("CITYwide"))
  expect_error(get_future_years_of_incarceration(c("citywide", NA)))
  expect_error(get_future_years_of_incarceration(mean()))
  expect_error(get_future_years_of_incarceration(c("citywide", NA, NULL)))
  expect_error(get_future_years_of_incarceration(c("citywide", "police_district", "census_tract", "zip_code")))
  expect_error(get_future_years_of_incarceration(wdasfgh))

  expect_error(get_future_years_of_supervision(NA))
  expect_error(get_future_years_of_supervision(7))
  expect_error(get_future_years_of_supervision(mtcars))
  expect_error(get_future_years_of_supervision(mtcars$mpg))
  expect_error(get_future_years_of_supervision(c("geography", "citywide")))
  expect_error(get_future_years_of_supervision("CITYwide"))
  expect_error(get_future_years_of_supervision(c("citywide", NA)))
  expect_error(get_future_years_of_supervision(mean()))
  expect_error(get_future_years_of_supervision(c("citywide", NA, NULL)))
  expect_error(get_future_years_of_supervision(c("citywide", "police_district", "census_tract", "zip_code")))
  expect_error(get_future_years_of_supervision(wdasfgh))

  expect_error(get_summary_arrests(NA))
  expect_error(get_summary_arrests(7))
  expect_error(get_summary_arrests(mtcars))
  expect_error(get_summary_arrests(mtcars$mpg))
  expect_error(get_summary_arrests(c("geography", "citywide")))
  expect_error(get_summary_arrests("CITYwide"))
  expect_error(get_summary_arrests(c("citywide", NA)))
  expect_error(get_summary_arrests(mean()))
  expect_error(get_summary_arrests(c("citywide", NA, NULL)))
  expect_error(get_summary_arrests(c("citywide", "police_district", "census_tract", "zip_code")))
  expect_error(get_summary_arrests(wdasfgh))

  expect_error(get_summary_case_length(NA))
  expect_error(get_summary_case_length(7))
  expect_error(get_summary_case_length(mtcars))
  expect_error(get_summary_case_length(mtcars$mpg))
  expect_error(get_summary_case_length(c("geography", "citywide")))
  expect_error(get_summary_case_length("CITYwide"))
  expect_error(get_summary_case_length(c("citywide", NA)))
  expect_error(get_summary_case_length(mean()))
  expect_error(get_summary_case_length(c("citywide", NA, NULL)))
  expect_error(get_summary_case_length(c("citywide", "police_district", "census_tract", "zip_code")))
  expect_error(get_summary_case_length(wdasfgh))

  expect_error(get_summary_case_outcomes(NA))
  expect_error(get_summary_case_outcomes(7))
  expect_error(get_summary_case_outcomes(mtcars))
  expect_error(get_summary_case_outcomes(mtcars$mpg))
  expect_error(get_summary_case_outcomes(c("geography", "citywide")))
  expect_error(get_summary_case_outcomes("CITYwide"))
  expect_error(get_summary_case_outcomes(c("citywide", NA)))
  expect_error(get_summary_case_outcomes(mean()))
  expect_error(get_summary_case_outcomes(c("citywide", NA, NULL)))
  expect_error(get_summary_case_outcomes(c("citywide", "police_district", "census_tract", "zip_code")))
  expect_error(get_summary_case_outcomes(wdasfgh))

  expect_error(get_summary_charges(NA))
  expect_error(get_summary_charges(7))
  expect_error(get_summary_charges(mtcars))
  expect_error(get_summary_charges(mtcars$mpg))
  expect_error(get_summary_charges(c("geography", "citywide")))
  expect_error(get_summary_charges("CITYwide"))
  expect_error(get_summary_charges(c("citywide", NA)))
  expect_error(get_summary_charges(mean()))
  expect_error(get_summary_charges(c("citywide", NA, NULL)))
  expect_error(get_summary_charges(c("citywide", "police_district", "census_tract", "zip_code")))
  expect_error(get_summary_charges(wdasfgh))
})
