% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Tagloss_cumul.R
\name{Tagloss_cumul}
\alias{Tagloss_cumul}
\title{Return the cumulative rate of tag loss.}
\usage{
Tagloss_cumul(
  t,
  par = NULL,
  Hessian = NULL,
  mcmc = NULL,
  method = NULL,
  model_before = NULL,
  model_after = NULL,
  model = NULL,
  replicates = NULL,
  x = NULL
)
}
\arguments{
\item{t}{Time for which values of model must be estimated}

\item{par}{Parameters}

\item{Hessian}{Hessian matrix of parameters}

\item{mcmc}{A mcmc result}

\item{method}{Can be NULL, "delta", "SE", "Hessian", "MCMC", or "PseudoHessianFromMCMC"}

\item{model_before}{Function to be used before estimation of daily tagloss rate}

\item{model_after}{Function to be used after estimation of daily tagloss rate}

\item{model}{The model of parameter to use, can be N2, N1 or N0; or NLR, NL0, N0R, or N00 or NULL if hessian is NULL.}

\item{replicates}{Number of replicates to estimate se of output for resampling method}

\item{x}{A Tagloss fitted model}
}
\value{
Return the cumulative rate of tag loss if hessian is null or a data.frame with distribution of cumulative rate of tag loss if hessian is not null.
}
\description{
This function compute a model of cumulative tag loss rate for days t 
based on a set of parameters, par.\cr
If hessian is not null, it will estimate standard error of the output using numerical delta method is replicates 
is null or using resampling if replicates is not null.\cr
Parameters are described in \code{\link{Tagloss_fit}}.
}
\details{
Tagloss_cumul returns the cumulative rate of tag loss.
}
\examples{
\dontrun{
# Example
library(phenology)

# Data from Rivalan et al. 2005 - Table 2, line 1 - Fig 1D
par <- c(a0_2=-5.43E-2, a1_2=-103.52, a2_2=0, a3_2=0, a4_2=5.62E-4)
(y <- Tagloss_cumul(t=(1:6)*365, par=par))
plot(y[, "time"], y[, "N2"], type="l", bty="n", 
     xlab="Days after tagging", ylab="N2 proportion")

# Data from Rivalan et al. 2005 - Table 2, line 2 - Fig 1E
par <- c(a0_2=-6.80E-2, a1_2=-81.15, a2_2=-2.20E-4, a3_2=6348.01, a4_2=1.65E-3)
(y <- Tagloss_cumul(t=(1:6)*365, par=par))
plot(y[, "time"], y[, "N2"], type="l", 
     xlab="Days after tagging", ylab="N2 proportion")

# Data from Rivalan et al. 2005 - Table 2, line 3 - Fig 1F
par <- c(a0_2=-6.93E-2, a1_2=-78.92, a2_2=8.45E-4, a3_2=-16272.76, a4_2=2.87E-4)
(y <- Tagloss_cumul(t=(1:6)*365, par=par))
plot(y[, "time"], y[, "N2"], type="l", 
     xlab="Days after tagging", ylab="N2 proportion")

# Data from Rivalan et al. 2005 - Table 2, line 4 - Fig 1C
par <- c(a0_2=-1.68E-3, a1_2=-4141.68, a2_2=0, a3_2=0, a4_2=0)
(y <- Tagloss_cumul(t=(1:6)*365, par=par))
plot(y[, "time"], y[, "N2"], type="l", 
     xlab="Days after tagging", ylab="N2 proportion")

# Data from Rivalan et al. 2005 - Table 2, line 5 - Fig 1B
par <- c(a0_2=-3.77E-4, a1_2=-2000, a2_2=-0.001, a3_2=0, a4_2=5.00E-8)
(y <- Tagloss_cumul(t=(1:6)*365, par=par))
plot(y[, "time"], y[, "N2"], type="l", 
     xlab="Days after tagging", ylab="N2 proportion")

# Data from Rivalan et al. 2005 - Table 2, line 6 - Fig 1A
par <- c(a0_2=-1E5, a1_2=-2000, a2_2=0, a3_2=4000, a4_2=8.34E-4)
(y <- Tagloss_cumul(t=(1:6)*365, par=par))
plot(y[, "time"], y[, "N2"], type="l", 
     xlab="Days after tagging", ylab="N2 proportion")
     
# Data from Rivalan et al. 2005 - Table 2, line 1 - Fig 1D
# With tagloss rate dependency on tage number
par <- c(a0_2=-5.43E-2, a1_2=-103.52, a2_2=0, a3_2=0, a4_2=5.62E-4, 
         a0_1=-5.43E-2, a1_1=-103.52, a2_1=0, a3_1=0, a4_1=5.62E-4, delta_1=3.2E-4)
phenology:::plot.Tagloss(x=list(), t=1:1000, fitted.parameters=par, 
                         model="Cumul", 
                         decoration = TRUE)

p2 <- Tagloss_model(t=1:(6*365), par=par, model="2")
p1 <- Tagloss_model(t=1:(6*365), par=par, model="1")
par(mar=c(4, 5, 2, 1))
plot(x=1:(6*365), y=p2, bty="n", type="l", las=1, ylim=c(0,0.003), ylab="")
mtext("Daily tag loss", side=2, line=4)
lines(x=1:(6*365), y=p1, col="red")
legend("topright", legend=c("2>1", "1>0"), lty=1, col=c("black", "red"))

Tagloss_cumul(t=(1:6)*365, par=par)

# Without tagloss rate dependency on tag number
par <- c(a0_2=-5.43E-2, a1_2=-103.52, a2_2=0, a3_2=0, a4_2=5.62E-4, 
         a0_1=-5.43E-2, a1_1=-103.52, a2_1=0, a3_1=0, a4_1=5.62E-4)
phenology:::plot.Tagloss(x=list(), t=1:1000, fitted.parameters=par, 
                         model="Cumul", 
                         decoration = TRUE)
Tagloss_cumul(t=(1:6)*365, par=par)

#### Data from Casale et al. 2017
# Table 1 - Model II
par <- c(CasaleModelIIa0_2=-0.0511, CasaleModelIIa1_2=-100, CasaleModelIIa4_2=0.00014)
phenology:::plot.Tagloss(x=list(), t=1:1000, fitted.parameters=par, 
                         model="Cumul", 
                         decoration = TRUE)
Tagloss_cumul(t=(1:6)*365, par=par)

# Table 1 - Model IV
par <- c(CasaleModelIVa0_2=-0.0132, CasaleModelIVa1_2=-100, 
         CasaleModelIVa2_2=0.0327, CasaleModelIVa3_2=109.98, 
         CasaleModelIVa4_2=0.00011)
phenology:::plot.Tagloss(x=list(), t=1:1000, fitted.parameters=par, 
                         model="Cumul", 
                         decoration = TRUE)
Tagloss_cumul(t=(1:6)*365, par=par)

# Table 1 - Model I
par <- c(CasaleModelIc_2=0.00027)
phenology:::plot.Tagloss(x=list(), t=1:1000, fitted.parameters=par, 
                         model="Cumul", 
                         decoration = TRUE)
Tagloss_cumul(t=(1:6)*365, par=par)

# Table 1 - Model III
par <- c(CasaleModelIIIa0_2=1.14E-10, CasaleModelIIIa1_2=-110.04, 
         CasaleModelIIIa4_2=0.00055)
phenology:::plot.Tagloss(x=list(), t=1:1000, fitted.parameters=par, 
                         model="Cumul", 
                         decoration = TRUE)
Tagloss_cumul(t=(1:6)*365, par=par)

# Table 1 - Model V
par <- c(CasaleModelVa0_2=4.04E-10, CasaleModelVa1_2=-90, 
         CasaleModelVa2_2=-0.0326, CasaleModelVa3_2=100.31, 
         CasaleModelVa4_2=0.00006)
phenology:::plot.Tagloss(x=list(), t=1:1000, fitted.parameters=par, 
                         model="Cumul", 
                         decoration = TRUE)
Tagloss_cumul(t=(1:6)*365, par=par)

}
}
\seealso{
Other Model of Tag-loss: 
\code{\link{Tagloss_LengthObs}()},
\code{\link{Tagloss_L}()},
\code{\link{Tagloss_daymax}()},
\code{\link{Tagloss_fit}()},
\code{\link{Tagloss_format}()},
\code{\link{Tagloss_mcmc_p}()},
\code{\link{Tagloss_mcmc}()},
\code{\link{Tagloss_model}()},
\code{\link{Tagloss_simulate}()},
\code{\link{logLik.Tagloss}()},
\code{\link{o_4p_p1p2}},
\code{\link{plot.TaglossData}()},
\code{\link{plot.Tagloss}()}
}
\author{
Marc Girondot \email{marc.girondot@gmail.com}
}
\concept{Model of Tag-loss}
