% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/par_init.R
\name{par_init}
\alias{par_init}
\title{Calculate initial set of parameters.}
\usage{
par_init(data = stop("A dataset must be provided"),
  fixed.parameters = NULL, add.cofactors = NULL)
}
\arguments{
\item{data}{Dataset generated with add_phenology()}

\item{fixed.parameters}{Set of fixed parameters}

\item{add.cofactors}{Names of cofactors that will be used (see fit_phenology)}
}
\value{
The initial set of parameters
}
\description{
This function is used to generate an initial set of parameters for fitting 
that is expected to be not to far from the final.\cr
The parameters can be:\cr
\itemize{
  \item \code{Min}, \code{MinE}, \code{MinB}, \code{PMin}, \code{PMinB}, \code{PMinE};
  \item \code{Max};
  \item \code{Begin}, \code{Peak}, \code{Flat}, \code{End};
  \item \code{Length}, \code{LengthB}, \code{LengthE};
  \item \code{Theta};
  \item \code{Alpha}, \code{Beta}, \code{Tau}, \code{Phi}, \code{Delta};
  \item \code{Alpha1}, \code{Beta1}, \code{Tau1}, \code{Phi1}, \code{Delta1};
  \item \code{Alpha2}, \code{Beta2}, \code{Tau2}, \code{Phi2}, \code{Delta2};
  \item \code{Alpha3}, \code{Beta3}, \code{Tau3}, \code{Phi3}, \code{Delta3};
}
And the name of level if a cofactor is used.\cr
The parameters \code{Max}, \code{Min}, \code{MinE}, \code{MinB}, \code{Length}, 
\code{LengthB}, \code{LengthE}, and \code{Peak} can be followed with _ and the 
name of the rookery.
}
\details{
par_init calculates initial set of parameters.
}
\examples{
\dontrun{
library(phenology)
# Read a file with data
Gratiot <- read.delim("http://max2.ese.u-psud.fr/epc/conservation/BI/Complete.txt", 
header=FALSE)
data(Gratiot)
# Generate a formatted list nammed data_Gratiot 
data_Gratiot <- add_phenology(Gratiot, name="Complete", 
		reference=as.Date("2001-01-01"), format="\%d/\%m/\%Y")
# Generate initial points for the optimisation
parg <- par_init(data_Gratiot, fixed.parameters=NULL)
# Run the optimisation
result_Gratiot <- fit_phenology(data=data_Gratiot, 
		fitted.parameters=parg, fixed.parameters=NULL)
data(result_Gratiot)
# Plot the phenology and get some stats
output<-plot(result_Gratiot)
}
}
\author{
Marc Girondot
}
