% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitRMU_MHmcmc.R
\name{fitRMU_MHmcmc}
\alias{fitRMU_MHmcmc}
\title{Run the Metropolis-Hastings algorithm for RMU.data}
\usage{
fitRMU_MHmcmc(
  result = stop("An output from fitRMU() must be provided"),
  n.iter = 10000,
  parametersMCMC = stop("A parameter set from fitRMU_MHmcmc_p() must be provided"),
  n.chains = 1,
  n.adapt = 0,
  thin = 1,
  adaptive = FALSE,
  adaptive.lag = 500,
  adaptive.fun = function(x) {
     ifelse(x > 0.234, 1.3, 0.7)
 },
  trace = FALSE,
  traceML = FALSE,
  intermediate = NULL,
  filename = "intermediate.Rdata",
  previous = NULL
)
}
\arguments{
\item{result}{An object obtained after a SearchR fit}

\item{n.iter}{Number of iterations for each step}

\item{parametersMCMC}{A set of parameters used as initial point for searching with information on priors}

\item{n.chains}{Number of replicates}

\item{n.adapt}{Number of iterations before to store outputs}

\item{thin}{Number of iterations between each stored output}

\item{adaptive}{Should an adaptive process for SDProp be used}

\item{adaptive.lag}{Lag to analyze the SDProp value in an adaptive content}

\item{adaptive.fun}{Function used to change the SDProp}

\item{trace}{TRUE or FALSE or period, shows progress}

\item{traceML}{TRUE or FALSE to show ML}

\item{intermediate}{Period for saving intermediate result, NULL for no save}

\item{filename}{If intermediate is not NULL, save intermediate result in this file}

\item{previous}{Previous result to be continued. Can be the filename in which intermediate results are saved.}
}
\value{
A list with resultMCMC being mcmc.list object, resultLnL being likelihoods and parametersMCMC being the parameters used
}
\description{
Run the Metropolis-Hastings algorithm for RMU.data.\cr
The number of iterations is n.iter+n.adapt+1 because the initial likelihood is also displayed.\cr
I recommend thin=1 because the method to estimate SE uses resampling.\cr
As initial point is maximum likelihood, n.adapt = 0 is a good solution.\cr
The parameters intermediate and filename are used to save intermediate results every 'intermediate' iterations (for example 1000). Results are saved in a file of name filename.\cr
The parameter previous is used to indicate the list that has been save using the parameters intermediate and filename. It permits to continue a mcmc search.\cr
These options are used to prevent the consequences of computer crash or if the run is very very long and computer processes at time limited.\cr
}
\details{
fitRMU_MHmcmc runs the Metropolis-Hastings algorithm for RMU.data (Bayesian MCMC)
}
\examples{
\dontrun{
library("phenology")
RMU.names.AtlanticW <- data.frame(mean=c("Yalimapo.French.Guiana", 
                                         "Galibi.Suriname", 
                                         "Irakumpapy.French.Guiana"), 
                                 se=c("se_Yalimapo.French.Guiana", 
                                      "se_Galibi.Suriname", 
                                      "se_Irakumpapy.French.Guiana"))
data.AtlanticW <- data.frame(Year=c(1990:2000), 
      Yalimapo.French.Guiana=c(2076, 2765, 2890, 2678, NA, 
                               6542, 5678, 1243, NA, 1566, 1566),
      se_Yalimapo.French.Guiana=c(123.2, 27.7, 62.5, 126, NA, 
                                 230, 129, 167, NA, 145, 20),
      Galibi.Suriname=c(276, 275, 290, NA, 267, 
                       542, 678, NA, 243, 156, 123),
      se_Galibi.Suriname=c(22.3, 34.2, 23.2, NA, 23.2, 
                           4.3, 2.3, NA, 10.3, 10.1, 8.9),
      Irakumpapy.French.Guiana=c(1076, 1765, 1390, 1678, NA, 
                               3542, 2678, 243, NA, 566, 566),
      se_Irakumpapy.French.Guiana=c(23.2, 29.7, 22.5, 226, NA, 
                                 130, 29, 67, NA, 15, 20))
                           
cst <- fitRMU(RMU.data=data.AtlanticW, RMU.names=RMU.names.AtlanticW, 
               colname.year="Year", model.trend="Constant", 
               model.SD="Zero")
pMCMC <- fitRMU_MHmcmc_p(result=cst, accept=TRUE)
fitRMU_MCMC <- fitRMU_MHmcmc(result = cst, n.iter = 10000, 
parametersMCMC = pMCMC, n.chains = 1, n.adapt = 0, thin = 1, trace = FALSE)
}
}
\seealso{
Other Fill gaps in RMU: 
\code{\link{CI.RMU}()},
\code{\link{fitRMU}()},
\code{\link{fitRMU_MHmcmc_p}()},
\code{\link{logLik.fitRMU}()},
\code{\link{plot.fitRMU}()}
}
\author{
Marc Girondot
}
\concept{Fill gaps in RMU}
