% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PhenoDeriv.R
\name{PhenoDeriv}
\alias{PhenoDeriv}
\alias{PhenoDeriv.fFIT}
\alias{PhenoDeriv.default}
\title{Phenology extraction in Derivative method (DER)}
\usage{
PhenoDeriv(x, t, ...)

\method{PhenoDeriv}{fFIT}(x, t = NULL, analytical = FALSE, smoothed.spline = FALSE, ...)

\method{PhenoDeriv}{default}(x, t, der1, IsPlot = TRUE, show.legend = TRUE, ...)
}
\arguments{
\item{x}{numeric vector, or \code{fFIT} object returned by \code{\link[=curvefit]{curvefit()}}.}

\item{t}{\code{doy} vector, corresponding doy of vegetation index.}

\item{...}{Other parameters will be ignored.}

\item{analytical}{If true, \code{numDeriv} package \code{grad} and \code{hess}
will be used; if false, \code{D1} and \code{D2} will be used.}

\item{smoothed.spline}{Whether apply \code{smooth.spline} first?}

\item{der1}{the first order difference}

\item{IsPlot}{whether to plot?}

\item{show.legend}{whether show figure lelend?}
}
\description{
Phenology extraction in Derivative method (DER)
}
\references{
\enumerate{
\item Filippa, G., Cremonese, E., Migliavacca, M., Galvagno, M., Forkel, M.,
Wingate, L., … Richardson, A. D. (2016). Phenopix: A R package for
image-based vegetation phenology. Agricultural and Forest Meteorology,
220, 141–150. \doi{10.1016/j.agrformet.2016.01.006}
}
}
\seealso{
\code{\link[=PhenoTrs]{PhenoTrs()}}, \code{\link[=PhenoGu]{PhenoGu()}}, \code{\link[=PhenoKl]{PhenoKl()}}
}
