% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/season.R, R/season_mov.R
\name{season}
\alias{season}
\alias{season_mov}
\alias{stat_season}
\title{Growing season dividing}
\usage{
season(INPUT, rFUN = wWHIT, wFUN = wTSM, iters = 2, wmin = 0.1,
  lambda, nf = 3, frame = floor(INPUT$nptperyear/5) * 2 + 1,
  minpeakdistance, r_max = 0.2, r_min = 0.05, ypeak_min = 0.1,
  rtrough_max = 0.6, MaxPeaksPerYear = 2, MaxTroughsPerYear = 3,
  IsPlot = FALSE, plotdat = INPUT, print = FALSE, adj.param = TRUE,
  ...)

season_mov(INPUT, rFUN = wWHIT, wFUN = wTSM, iters = 2, wmin = 0.1,
  IsOptim_lambda = FALSE, lambda = NULL, nf = 3,
  frame = floor(INPUT$nptperyear/5) * 2 + 1, maxExtendMonth = 12, ...,
  IsPlot = TRUE, IsPlot.vc = FALSE, IsPlot.OnlyBad = FALSE,
  plotdat = INPUT, print = TRUE, titlestr = "")

stat_season(INPUT, brks)
}
\arguments{
\item{INPUT}{A list object with the elements of \code{t}, \code{y}, \code{w}, 
\code{Tn} (optional) and \code{ylu}, returned by \code{\link{check_input}}.}

\item{rFUN}{Rough curve fitting function, can be one of \code{\link{wSG}}, 
\code{\link{wWHIT}} and \code{\link{wHANTS}}.}

\item{wFUN}{weights updating function, can be one of \code{\link{wTSM}}, 
\code{\link{wChen}}, \code{\link{wBisquare}} and \code{\link{wSELF}}.}

\item{iters}{How many times curve fitting is implemented.}

\item{wmin}{Double, minimum weigth (i.e. weight of snow, ice and cloud).}

\item{lambda}{The smoothing parameter of \code{\link{wWHIT}}. For 
\code{\link{season_mov}}, if lambda is \code{NULL}, \code{\link{init_lambda}}
will be used. Generally, it was set as 10000, 15, and 5 for daily, 8-day 
and 16-day inputs respectively.}

\item{nf}{The parameter of \code{\link{wHANTS}}, number of frequencies to be
considered above the zero frequency.}

\item{frame}{The parameter of \code{\link{wSG}}, moving window size. Suggested by
TIMESAT, default \code{frame = floor(nptperyear/7)*2 + 1}.}

\item{minpeakdistance}{Numberic, in the unit of points (default as 
\code{nptperyear/6}). The minimum distance of two peaks. If the distance of two
maximum extreme value less than \code{minpeakdistance}, only the real maximum
value will be left.}

\item{r_max}{Similar as \code{r_min}, The maximum threshold should
be greater than \code{r_max}.}

\item{r_min}{Threshold is defined as the difference of peak value with
trough value. There are two threshold (left and right). The minimum threshold
should be greater than r_min.}

\item{ypeak_min}{ypeak >= ypeak_min}

\item{rtrough_max}{\code{ytrough <= rtrough_max*A}, A is the amplitude of y.}

\item{MaxPeaksPerYear}{This parameter is used to adjust lambda in iterations.
If PeaksPerYear > MaxPeaksPerYear, then lambda = lambda*2.}

\item{MaxTroughsPerYear}{This parameter is used to adjust lambda in iterations.
If TroughsPerYear > MaxTroughsPerYear, then lambda = lambda*2.}

\item{IsPlot}{Boolean}

\item{plotdat}{A list or data.table, with \code{t}, \code{y} and \code{w}. 
Only if \code{IsPlot=TRUE}, \code{\link{plot_input}} will be used to plot. 
Known that y and w in \code{INPUT} have been changed, we suggest using the 
original data.table.}

\item{print}{Whether to print progress information}

\item{adj.param}{Adjust rough curve fitting function parameters automatically, 
if too many or to less peak and trough values.}

\item{...}{For \code{\link{season_mov}}, Other parameters passed to 
\code{\link{season}}; For \code{\link{season}}, other parameters passed to 
\code{\link{findpeaks}}.}

\item{IsOptim_lambda}{Whether to optimize Whittaker's parameter lambda by
V-curve theory?}

\item{maxExtendMonth}{Previous and subsequent `maxExtendMonth` data were added
for every year curve fitting.}

\item{IsPlot.vc}{Whether to plot V-curve optimized time-series.}

\item{IsPlot.OnlyBad}{If true, only plot partial figures whose NSE < 0.3.}

\item{titlestr}{string for title}

\item{brks}{A list object returned by \code{season} or \code{season_mov}.}
}
\value{
\describe{
\item{whit}{Rough fitting result.}
\item{dt}{Growing season dividing information.}
}

List object, list(whit, dt)
}
\description{
Divide growing seasons according to rough fitting (\code{rFUN}) result .

For \code{season}, rough fitting is applied for whole.
For \code{season_mov} rough fitting is applied in every year, during which 
\code{maxExtendMonth} is extended.
}
\details{
Before dividing growing season, \code{INPUT} should be added a year in head 
and tail first by \code{add_HeadTail}.

Finally, use \code{\link{findpeaks}} to get local maximum and local minimum values.
Two local minimum define a growing season. 
If two local minimum(maximum) are too closed, then only the smaller(biger) is left.
}
\examples{
library(phenofit)
data("MOD13A1")

df <- tidy_MOD13.gee(MOD13A1$dt)
st <- MOD13A1$st

date_start <- as.Date('2013-01-01')
date_end   <- as.Date('2016-12-31')

sitename <- 'CA-NS6' # df$site[1]
d     <- df[site == sitename & (date >= date_start & date <= date_end), ]
sp    <- st[site == sitename, ]
south <- sp$lat < 0
nptperyear <- 23

# global parameter
IsPlot = TRUE
print  = FALSE
ypeak_min  = 0.05
wFUN = wTSM

# add one year in head and tail
dnew     <- add_HeadTail(d, south = south, nptperyear = nptperyear) 
INPUT    <- check_input(dnew$t, dnew$y, dnew$w, QC_flag = dnew$QC_flag,
     nptperyear = nptperyear, south = south, 
     maxgap = nptperyear/4, alpha = 0.02, wmin = 0.2)
# all year as a whole
brks  <- season(INPUT,
    rFUN = wWHIT, wFUN = wFUN,
    lambda = 10,
    plotdat = d, IsPlot = IsPlot, print = FALSE, IsPlot.OnlyBad = FALSE)
# curve fitting by year
brks2 <- season_mov(INPUT,
    rFUN = wWHIT, wFUN = wFUN,
    lambda = 10,
    plotdat = d, IsPlot = IsPlot, print = FALSE, IsPlot.OnlyBad = FALSE)
}
\seealso{
\code{\link{findpeaks}}.
}
