% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_input.R
\name{check_input}
\alias{check_input}
\title{check_input}
\usage{
check_input(t, y, w, QC_flag, nptperyear, south = FALSE, Tn = NULL,
  wmin = 0.2, missval, maxgap, alpha = 0.01, ...)
}
\arguments{
\item{t}{Numeric vector, \code{Date} variable}

\item{y}{Numeric vector, vegetation index time-series}

\item{w}{(optional) Numeric vector, weights of \code{y}. If not specified, 
weights of all \code{NA} values will be \code{wmin}, the others will be 1.0.}

\item{QC_flag}{Factor (optional) returned by \code{qcFUN}, levels should be
in the range of \code{c("snow", "cloud", "shadow", "aerosol", "marginal",
"good")}, others will be categoried into \code{others}. \code{QC_flag} is
used for visualization in \code{\link{get_pheno}} and
\code{\link{plot_phenofit}}.}

\item{nptperyear}{Integer, number of images per year.}

\item{south}{Boolean. In south hemisphere, growing year is 1 July to the
following year 31 June; In north hemisphere, growing year is 1 Jan to 31 Dec.}

\item{Tn}{Numeric vector, night temperature, default is null. If provided,
Tn is used to help divide ungrowing period, and then get background value in
ungrowing season (see details in \code{\link[phenofit]{backval}}).}

\item{wmin}{Double, minimum weigth (i.e. weight of snow, ice and cloud).}

\item{missval}{Double, which is used to replace NA values in y. If missing,
the default vlaue is \code{ylu[1]}.}

\item{maxgap}{Integer, nptperyear/4 will be a suitable value. If continuous
missing value numbers less than maxgap, then interpolate those NA values by
zoo::na.approx; If false, then replace those NA values with a constant value
\code{ylu[1]}. \cr
Replacing NA values with a constant missing value (e.g. background value ymin)
is inappropriate for middle growing season points. Interpolating all values
by na.approx, it is unsuitable for large number continous missing segments,
e.g. in the start or end of growing season.}

\item{alpha}{Double value in [0,1], quantile prob of ylu_min.}

\item{...}{Others will be ignored.}
}
\value{
A list object returned
\itemize{
\item{t } Numeric vector
\item{y0} Numeric vector, original vegetation time-series.
\item{y } Numeric vector, checked vegetation time-series, \code{NA} values 
are interpolated. 
\item{w } Numeric vector
\item{Tn} Numeric vector
\item{ylu} =[ymin, ymax]. \code{w_critical} is used to filter not too
     bad values. If the percentage good values (w=1) is greater than 30\%, then
     \code{w_critical}=1. The else, if the percentage of w >= 0.5 points is greater
     than 10\%, then \code{w_critical}=0.5. In boreal regions, even if the percentage
     of w >= 0.5 points is only 10\%, we still can't set \code{w_critical=wmin}.
     We can't rely on points with the wmin weights. Then,
     \code{y_good = y[w >= w_critical ]},
     \code{ymin = pmax( quantile(y_good, alpha/2), 0)}, \code{ymax = max(y_good)}.
}
}
\description{
Check input data, interpolate NA values in y, remove spike values, and set
weights for NA in y and w.
}
\examples{
library(phenofit)
data("MOD13A1")

df <- tidy_MOD13.gee(MOD13A1$dt)
st <- MOD13A1$st

date_start <- as.Date('2013-01-01')
date_end   <- as.Date('2016-12-31')

sitename <- 'CA-NS6' # df$site[1]
d     <- df[site == sitename & (date >= date_start & date <= date_end), ]
sp    <- st[site == sitename, ]
south <- sp$lat < 0
nptperyear <- 23

# global parameter
IsPlot = TRUE
print  = FALSE
ypeak_min  = 0.05
wFUN = wTSM

# add one year in head and tail
dnew     <- add_HeadTail(d, south = south, nptperyear = nptperyear) 
INPUT    <- check_input(dnew$t, dnew$y, dnew$w, QC_flag = dnew$QC_flag,
     nptperyear = nptperyear, south = south, 
     maxgap = nptperyear/4, alpha = 0.02, wmin = 0.2)
}
\seealso{
\code{\link[phenofit]{backval}}
}
