% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/example12.R
\name{example12}
\alias{example12}
\title{Example ODE System 12}
\usage{
example12(t, y, parameters)
}
\arguments{
\item{t}{The value of \ifelse{html}{\out{<i>t</i>}}{\eqn{t}}, the independent
variable, to evaluate the derivative at. Should be a single number.}

\item{y}{The values of \ifelse{html}{\out{<i>x</i>}}{\eqn{x}} and 
\ifelse{html}{\out{<i>y</i>}}{\eqn{y}}, the dependent
variables, to evaluate the derivative at. Should be a vector of length two.}

\item{parameters}{The values of the parameters of the system. Not required
here.}
}
\value{
Returns a list containing the values of the two derivatives
at \ifelse{html}{\out{(<i>t</i>, <i>x</i>, <i>y</i>)}}{\eqn{(t, x, y)}}.
}
\description{
The derivative function of an example two-dimensional autonomous ODE system.
}
\details{
\code{example12} evaluates the derivatives of the following coupled ODE system
at the point \ifelse{html}{\out{(<i>t</i>, <i>x</i>, <i>y</i>)}}{
\eqn{(t, x, y)}}:

\ifelse{html}{\out{<center><i>dx</i>/<i>dt</i> = <i>x</i> - <i>y</i>,
<i>dy</i>/<i>dt</i> = <i>x</i><sup>2</sup> + <i>y</i><sup>2</sup> - 2.</center>}}{\deqn{\frac{dx}{dt} = x - y, \frac{dy}{dt} = x^2 + y^2 - 2.}}

Its format is designed to be compatible with \code{\link[deSolve]{ode}} from
the \code{\link[deSolve]{deSolve}} package.
}
\examples{
# Plot the velocity field, nullclines and several trajectories
example12.flowField   <- flowField(example12,
                                   xlim = c(-4, 4),
                                   ylim = c(-4, 4),
                                   points = 17,
                                   add = FALSE)
y0                    <- matrix(c(2, 2, -3, 0,
                                  0, 2, 0, -3), 4, 2,
                                byrow = TRUE)
example12.nullclines  <- nullclines(example12,
                                    xlim = c(-4, 4),
                                    ylim = c(-4, 4),
                                    points = 200)
example12.trajectory  <- trajectory(example12,
                                    y0 = y0,
                                    tlim = c(0, 10))
example12.manifolds   <- drawManifolds(example12,
                                       y0 = c(-1, -1),
                                       tend = 1000,
                                       col = c("green", "red"),
                                       add.legend = TRUE)
# Determine the stability of the equilibrium points
example12.stability.1 <- stability(example12,
                                   ystar = c(1, 1))
example12.stability.2 <- stability(example12,
                                   ystar = c(-1, -1))
}
\seealso{
\code{\link[deSolve]{ode}}
}
\author{
Michael J. Grayling
}
