% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{remove_peripheral_compartment}
\alias{remove_peripheral_compartment}
\title{remove_peripheral_compartment}
\usage{
remove_peripheral_compartment(model)
}
\arguments{
\item{model}{(Model) Pharmpy model}
}
\value{
(Model) Reference to same model
}
\description{
Remove a peripheral distribution compartment from model

Initial estimates:

==  ===================================================
n
==  ===================================================
2   :math:\verb{\{CL\} = \{CL'\}},
:math:\verb{\{QP1\} = \{CL'\}} and :math:\verb{\{VP1\} = \{VC'\} * 0.05}
3   :math:\verb{\{QP1\} = (\{QP1'\} + \{QP2'\}) / 2},
:math:\verb{\{VP1\} = \{VP1'\} + \{VP2'\}}
==  ===================================================
}
\examples{
\dontrun{
model <- load_example_model("pheno")
set_peripheral_compartments(model, 2)
remove_peripheral_compartment(model)
model$statements$ode_system
}
}
\seealso{
set_peripheral_compartment

add_peripheral_compartment
}
