\name{phangorn-package}
\alias{phangorn-package}
\alias{phangorn}
\docType{package}
\title{
Phylogenetic analysis in R
}
\description{
Phylogenetic analysis in R (Estimation of phylogenetic
trees and networks using Maximum Likelihood, Maximum Parsimony,
Distance methods & Hadamard conjugation)

The complete list of functions can be displayed with \code{library(help = phangorn)}. 


Further information is available in several vignettes. To show the available 
vignettes in an HTML browser type \code{browseVignettes("phangorn")}. 
\tabular{ll}{
\code{Trees} \tab Constructing phylogenetic trees (source, pdf) \cr
\code{phangorn-specials} \tab Advanced features (source, pdf) \cr
\code{Ancestral} \tab Ancestral sequence reconstruction (source, pdf) \cr
\code{Networx} \tab Splits and Networx (source, html) \cr
}
The first vignette (to display type \code{vignette('Trees')}) gives an introduction in phylogenetic analysis with phangorn. The second vignette (phangorn-special) covers more advanced feature like defining special character spaces and things which fit nowhere else. 
More information on \bold{phangorn} can be found on \url{http://www.phangorn.org}. 
}
\author{
Klaus Schliep

Maintainer: Klaus Schliep <klaus.schliep@gmail.com>
}
\references{
  Schliep K.P. (2011) phangorn: Phylogenetic analysis in R.
  \emph{Bioinformatics}, 27(4) 592-593
}
\keyword{ package }
%\seealso{
%~~ Optional links to other man pages, e.g. ~~
%~~ \code{\link[<pkg>:<pkg>-package]{<pkg>}} ~~
%}
%\examples{
%~~ simple examples of the most important functions ~~
%}
