/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eps2pgf.ps.resources.filters;

import java.io.IOException;
import java.io.InputStream;
import net.sf.eps2pgf.ps.errors.PSError;
import net.sf.eps2pgf.ps.objects.PSObjectDict;
import net.sf.eps2pgf.ps.resources.filters.ASCIIHexDecode;

public class EexecDecode
extends InputStream {
    private InputStream in;
    private int n;
    private int r;
    private int c1;
    private int c2;
    private int markedR;

    public EexecDecode(InputStream inputStream) throws PSError {
        PSObjectDict pSObjectDict = new PSObjectDict();
        this.in = new ASCIIHexDecode(inputStream, pSObjectDict);
        this.n = 4;
        this.r = 55665;
        this.c1 = 52845;
        this.c2 = 22719;
    }

    public EexecDecode(InputStream inputStream, int n, boolean bl) throws PSError {
        if (bl) {
            this.in = inputStream;
        } else {
            PSObjectDict pSObjectDict = new PSObjectDict();
            this.in = new ASCIIHexDecode(inputStream, pSObjectDict);
        }
        this.n = 4;
        this.r = n;
        this.c1 = 52845;
        this.c2 = 22719;
    }

    public int available() throws IOException {
        return this.in.available() - this.n;
    }

    public void close() throws IOException {
        this.in = null;
    }

    public void mark(int n) {
        this.in.mark(n + this.n);
        this.markedR = this.r;
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    public int read() throws IOException {
        if (this.in == null) {
            return -1;
        }
        int n = this.in.read();
        if (n == -1) {
            return -1;
        }
        if (n > 255) {
            throw new IOException();
        }
        int n2 = this.r >>> 8;
        int n3 = n ^ n2;
        this.r = (n + this.r) * this.c1 + this.c2 & 0xFFFF;
        if (this.n > 0) {
            --this.n;
            n3 = this.read();
        }
        return n3;
    }

    public void reset() throws IOException {
        if (this.in == null) {
            throw new IOException();
        }
        this.in.reset();
        this.r = this.markedR;
    }
}

