% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel_gaussian.R
\name{gaussian_kernel_confidence}
\alias{gaussian_kernel_confidence}
\alias{kernel-gaussian}
\alias{gaussian_kernel_radius}
\title{Compute a Gaussian kernel}
\usage{
gaussian_kernel_confidence(
  vertical_r0 = 0.05,
  vertical_sd = 1,
  horizontal_r0 = vertical_r0,
  horizontal_sd = vertical_sd,
  tail_included = TRUE
)

gaussian_kernel_radius(
  vertical_radius,
  vertical_sd = 1,
  horizontal_radius = vertical_radius,
  horizontal_sd = vertical_sd,
  tail_included = TRUE
)
}
\arguments{
\item{vertical_r0}{\strong{[numeric]} The kernel's r0 (exponential) in the
vertical dimension.}

\item{vertical_sd}{\strong{[numeric]} The kernel's standard deviation in the
vertical dimension.}

\item{horizontal_r0}{\strong{[numeric]} The kernel's r0 (exponential) in the
horizontal dimension.}

\item{horizontal_sd}{\strong{[numeric]} The kernel's standard deviation in the
horizontal dimension.}

\item{tail_included}{\strong{[logical]} Whether or not to include the kernel
tail.}

\item{vertical_radius}{\strong{[numeric]} The kernel's radius in the vertical
dimension.}

\item{horizontal_radius}{\strong{[numeric]} The kernel's radius in the horizontal
dimension.}
}
\value{
A \code{matrix} corresponding to the kernel.
}
\description{
Functions to compute a Gaussian kernel.
}
\examples{

gaussian_kernel_confidence(vertical_r0 = 0.4, vertical_sd = 1, 
                           horizontal_r0 = 0.5, horizontal_sd = 2)
gaussian_kernel_confidence(vertical_r0 = 0.4, vertical_sd = 1, 
                           horizontal_r0 = 0.5, horizontal_sd = 2)

}
