% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vwReg.R
\name{vwReg}
\alias{vwReg}
\title{Visually Weighted Regression.}
\usage{
vwReg(
  formula,
  data,
  title = "",
  B = 1000,
  shade = TRUE,
  shade.alpha = 0.1,
  spag = FALSE,
  spag.color = "darkblue",
  mweight = TRUE,
  show.lm = FALSE,
  show.median = TRUE,
  median.col = "white",
  shape = 21,
  show.CI = FALSE,
  method = loess,
  bw = FALSE,
  slices = 200,
  palette = colorRampPalette(c("#FFEDA0", "#DD0000"), bias = 2)(20),
  ylim = NULL,
  quantize = "continuous",
  add = FALSE,
  ...
)
}
\arguments{
\item{formula}{regression model.}

\item{data}{dataset.}

\item{title}{plot title.}

\item{B}{number of bootstrapped smoothers.}

\item{shade}{whether to plot the shaded confidence region.}

\item{shade.alpha}{whether to fade out the confidence interval shading at
the edges (by reducing alpha; 0 = no alpha decrease, 0.1 = medium alpha
decrease, 0.5 = strong alpha decrease).}

\item{spag}{whether to plot spaghetti lines.}

\item{spag.color}{the fitting function for the spaghettis; default:
\code{loess}.}

\item{mweight}{logical indicating whether to make the median smoother
visually weighted.}

\item{show.lm}{logical indicating whether to plot the linear regression line.}

\item{show.median}{logical indicating whether to plot the median smoother.}

\item{median.col}{color of the median smoother.}

\item{shape}{shape of points.}

\item{show.CI}{logical indicating whether to plot the 95\% confidence
interval limits.}

\item{method}{color of spaghetti lines.}

\item{bw}{logical indicating whether to use a b&w palette; default:
\code{TRUE}.}

\item{slices}{number of slices in x and y direction for the shaded region.
Higher numbers make a smoother plot, but takes longer to draw. I would not
set \code{slices} to more than 500.}

\item{palette}{provide a custom color palette for the watercolors.}

\item{ylim}{restrict range of the watercoloring.}

\item{quantize}{either \code{continuous}, or \code{SD}. In the latter case, we get
three color regions for 1, 2, and 3 SD (an idea of John Mashey).}

\item{add}{if \code{add == FALSE}, a new ggplot is returned. If
\code{add == TRUE}, only the elements are returned, which can be added to an
existing ggplot (with the \code{+} operator).}

\item{...}{further parameters passed to the fitting function, in the case of
loess, for example, \code{span = .9}, or \code{family = "symmetric"}.}
}
\value{
plot
}
\description{
Create watercolor plot to visualize weighted regression.
}
\details{
Creates a watercolor plot to visualize weighted regression.
}
\examples{
\donttest{
# Prepare Data
data("mtcars")
df <- data.frame(x = mtcars$hp, y = mtcars$mpg)

## Visually Weighted Regression

# Default
vwReg(y ~ x, df)

# Shade
vwReg(y ~ x, df, shade = TRUE, show.lm = TRUE, show.CI = TRUE,
quantize = "continuous")
vwReg(y ~ x, df, shade = TRUE, show.lm = TRUE, show.CI = TRUE,
quantize = "SD")

# Spaghetti
vwReg(y ~ x, df, shade = FALSE, spag = TRUE, show.lm = TRUE, show.CI = TRUE)
vwReg(y ~ x, df, shade = FALSE, spag = TRUE)

# Black/white
vwReg(y ~ x, df, shade = TRUE, spag = FALSE, show.lm = TRUE, show.CI = TRUE,
bw = TRUE, quantize = "continuous")
vwReg(y ~ x, df, shade = TRUE, spag = FALSE, show.lm = TRUE, show.CI = TRUE,
bw = TRUE, quantize = "SD")
vwReg(y ~ x, df, shade = FALSE, spag = TRUE, show.lm = TRUE, show.CI = TRUE,
bw = TRUE, quantize = "SD")

# Change the bootstrap smoothing
vwReg(y ~ x, df, family = "symmetric") # use an M-estimator for
# bootstrap smoothers. Usually yields wider confidence intervals
vwReg(y ~ x, df, span = 1.7) # increase the span of the smoothers
vwReg(y ~ x, df, span = 0.5) # decrease the span of the smoothers

# Change the color scheme
vwReg(y ~ x, df, palette = viridisLite::viridis(4)) # viridis
vwReg(y ~ x, df, palette = viridisLite::magma(4)) # magma
vwReg(y ~ x, df, palette = RColorBrewer::brewer.pal(9, "YlGnBu")) # change the
# color scheme, using a predefined ColorBrewer palette. You can see all
# available palettes by using this command:
# `library(RColorBrewer); display.brewer.all()`
vwReg(y ~ x, df, palette = grDevices::colorRampPalette(c("white","yellow",
"green","red"))(20)) # use a custom-made palette
vwReg(y ~ x, df, palette = grDevices::colorRampPalette(c("white","yellow",
"green","red"), bias = 3)(20)) # use a custom-made palette, with the
# parameter bias you can shift the color ramp to the “higher” colors
vwReg(y ~ x, df, bw = TRUE) # black and white version
vwReg(y ~ x, df, shade.alpha = 0, palette = grDevices::colorRampPalette(
c("black","grey30","white"), bias = 4)(20)) # Milky-Way Plot
vwReg(y ~ x, df, shade.alpha = 0, slices = 400, palette =
grDevices::colorRampPalette(c("black","green","yellow","red"),
bias = 5)(20), family = "symmetric") # Northern Light Plot/ fMRI plot
vwReg(y ~ x, df, quantize = "SD") # 1-2-3-SD plot
}

}
\seealso{
\url{https://www.nicebread.de/visually-weighted-regression-in-r-a-la-solomon-hsiang/}

\url{https://www.nicebread.de/visually-weighted-watercolor-plots-new-variants-please-vote/}

\url{http://www.fight-entropy.com/2012/07/visually-weighted-regression.html}

\url{http://www.fight-entropy.com/2012/08/visually-weighted-confidence-intervals.html}

\url{http://www.fight-entropy.com/2012/08/watercolor-regression.html}

\url{https://papers.ssrn.com/sol3/papers.cfm?abstract_id=2265501}

Other plot: 
\code{\link{addText}()},
\code{\link{plot2WayInteraction}()},
\code{\link{ppPlot}()}

Other correlations: 
\code{\link{addText}()},
\code{\link{cor.table}()},
\code{\link{crossTimeCorrelation}()},
\code{\link{crossTimeCorrelationDF}()},
\code{\link{partialcor.table}()}
}
\concept{correlations}
\concept{plot}
