% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/public.R
\name{Pmat}
\alias{Pmat}
\title{Create a set of permutations.}
\usage{
Pmat(np = 5000, n, type = "default")
}
\arguments{
\item{np}{A numeric value for the number of permutations. Default is 5000.}

\item{n}{A numeric value for the number of observations.}

\item{type}{A character string to specify the type of matrix. See Details.}
}
\value{
A matrix n x np containing the permutations/coinflips. First permutation is the identity.
}
\description{
Compute a permutation matrix used as argument in \link{aovperm}, \link{lmperm}, \link{clusterlm} functions. The first column represents the identity permutation.
}
\details{
\code{type} can set to :\cr
\code{"default"} : \code{np} random with replacement permutations among the \code{n!} permutations.\cr
\code{"all"} : all \code{n!} possible permutations.\cr
}
\examples{
## data
data("emergencycost")

## Create a set of 2000 permutations
set.seed(42)
pmat = Pmat(np = 2000, n = nrow(emergencycost))

## centrering the covariate to the mean
emergencycost$LOSc <- scale(emergencycost$LOS, scale = FALSE)

## ANCOVA
mod_cost_0 <- aovperm(cost ~ LOSc*sex*insurance, data = emergencycost, np = 2000)
mod_cost_1 <- aovperm(cost ~ LOSc*sex*insurance, data = emergencycost, P = pmat)
mod_cost_2 <- aovperm(cost ~ LOSc*sex*insurance, data = emergencycost, P = pmat)

## Same p-values for both models 1 and 2 but differents of model 0
mod_cost_0
mod_cost_1
mod_cost_2

}
