% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloadableTable.R
\name{downloadableTableUI}
\alias{downloadableTableUI}
\title{downloadableTable UI}
\usage{
downloadableTableUI(id, downloadtypes = c("csv"), hovertext = NULL,
  contentHeight = "200px", singleSelect = FALSE)
}
\arguments{
\item{id}{character id for the object}

\item{downloadtypes}{vector of values for data download types}

\item{hovertext}{download button tooltip hover text}

\item{contentHeight}{viewable height of the table (any valid css size value)}

\item{singleSelect}{whether the table should only allow a single row to be
selected at a time (FALSE by default allows multi-select).}
}
\description{
Creates a custom high-functionality table paired with a linked downloadFile
button.  The table has search and highlight functionality, infinite scrolling,
sorting by columns and returns a reactive dataset of selected items.
}
\section{Table Features}{

\itemize{
    \item Consistent styling of the table
    \item downloadFile module button functionality built-in to the table
    \item Ability to show different data from the download data
    \item Table is automatically fit to the window size with infinite
    y-scrolling
    \item Table search functionality including highlighting built-in
    \item Multi-select built in, including reactive feedback on which table
    items are selected
}
}

\section{Example}{

\code{downloadableTableUI("mytableID", c("csv", "tsv"),
"Click Here", "300px")}
}

\section{Notes}{

When there are no rows to download in any of the linked downloaddatafxns the
button will be hidden as there is nothing to download.  The linked
downloaddatafxns are set in the paired callModule (see the \strong{Shiny Usage}
section)
}

\section{Shiny Usage}{

Call this function at the place in ui.R where the table should be placed.

Paired with a call to \code{shiny::callModule(downloadableTable, id, ...)}
in server.R
}

\examples{
# Inside ui_body.R or ui_sidebar.R
downloadableTableUI("object_id1", 
                    downloadtypes = c("csv", "tsv"), 
                    hovertext = "Download the data here!",
                    contentHeight = "300px",
                    singleSelect = FALSE)

}
\seealso{
\link[periscope]{downloadableTable}

\link[periscope]{downloadFileButton}
}
